<?php

/******************************************************************************
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
*
* Catlair PHP
* Work with Decript content
*
* 16.03.2019
*
* still@itserv.ru
*
*/


class DescriptContent extends TCMSController
{
    /*
    Buid content list.
    */
    public function &Load()
    {
        /* List of conditions */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();

        $RecordCurrent = (int) $this->GetIncome('RecordCurrent', 0);
        $RecordCount = (int) $this->GetIncome('RecordCount', 5);
        $IDParent = (string) $this->GetIncome('IDParent', null);
        $ID = $this->GetIncome('ID', null);
        $IDType = $this->GetIncome('IDType', null);
        $IDRecord = $this->GetIncome('IDRecord', null);
        $Find = rawurldecode($this->GetIncome('Find', ''));

        /* Create find string */
        if ($ID!=null) $Find .= ' ' . clIndexIDString($ID);
        if ($IDType!=null) $Find .= ' ' . clIndexTypeString($IDType);
        $Find = trim($Find);

        /* Build records by findstring */
        $Descripts = new TDescripts();
        $Descripts->LoadFromIndex($IDSite, $IDLang, $Find, $IDParent, BIND_DEFAULT);

        /* Get total records */
        $this->SetGroup('Records', 'RecordTotal', $Descripts->RecordCount());

        /* Get descripts data */
        $Descripts->SelectDescript($IDSite, $IDLang, 'ID', BIND_DEFAULT);

        /* Sorting */
        $Descripts->Sort('DTActual', -1);

        /* Paging */
        $Descripts->Cut($RecordCurrent, $RecordCount);

        /* Read content */
        $Descripts->SelectDescriptFields($IDSite, $IDLang, 'ID', ['Content'=>'Content']);
        $Descripts->SelectPreview('Content', 'Preview', 3000);

        /* Set record current */
        $this->SetGroup('Records', 'RecordCurrent', $RecordCurrent+$Descripts->RecordCount());

        /* Return records*/
        $RecordContent = clDescriptContentByID($IDRecord, $IDSite, $IDLang);

        unset($Descript);

        $this->SetContent($Descripts->BuildContent($RecordContent, 2));

        return $this;
    }



    /*
    Descript list
    Build descript list without content and return
    */
    public function &List()
    {
        /* List of conditions */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();

        $RecordCurrent = (int) $this->GetIncome('RecordCurrent', 0);
        $RecordCount = 1000; /*(int) $this->GetIncome('RecordCount', 5);*/
        $IDParent = (string) $this->GetIncome('IDParent', null);
        $ID = $this->GetIncome('ID', null);
        $IDType = $this->GetIncome('IDType', null);
        $IDRecord = $this->GetIncome('IDRecord', null);
        $Find = rawurldecode($this->GetIncome('Find', ''));
        $IDBind = $this->GetIncome('IDBind', BIND_DEFAULT);

        /* Create find string */
        if ($ID!=null) $Find .= ' ' . clIndexIDString($ID);
        if ($IDType!=null) $Find .= ' ' . clIndexTypeString($IDType);
        $Find = trim($Find);

        /* Построение списка дескриптов и возврат в виде записей */
        $Descripts = new TDescripts();
        $Descripts->LoadFromIndex($IDSite, $IDLang, $Find, $IDParent, $IDBind);

        $Descripts->SelectDescript($IDSite, $IDLang, 'ID', $IDBind); /* получение данных дескрипта */
        $Descripts->SelectChildsCount($IDSite, 'ID', $IDBind); /* получение данных дескрипта */

        /* Сортиторвка  */
        $Parent = new TDescript();
        $Result = $Parent->Read($IDParent, $IDSite);
        switch ($Parent->Get('Sort',''))
        {
            case 'ID': $Descripts->Sort('ID', 1); break;
            case 'CaptionAZ': $Descripts->Sort('Caption', 1); break;
            case 'CaptionZA': $Descripts->Sort('Caption', -1); break;
            case 'DTInsert09': $Descripts->Sort('DTInsert', 1); break;
            case 'DTInsert90': $Descripts->Sort('DTInsert', -1); break;
            case 'DTActual09': $Descripts->Sort('DTActual', 1); break;
            case 'DTActual90': $Descripts->Sort('DTActual', -1); break;
        }
        unset($Parent);

        /* Общее количество записей */
        $this->SetGroup('Records', 'RecordTotal', $Descripts->RecordCount());

        $Descripts->Cut($RecordCurrent, $RecordCount); /* отсекли только необходимые для пагинации */
        $Descripts->SelectCaptionType($IDSite, $IDLang, 'ID', 'CaptionType'); /* получение caption */
        $Descripts->Set(['IDParent'=>$IDParent]); /* Прописали всем текущего запаршиваемого парента */
        $Descripts->BuildResult($this, 'Records');

        /* Сохранение параметров */
        $this->SetGroup('Records', 'RecordCurrent', $RecordCurrent+$Descripts->RecordCount());

        unset($Descript);

        /* Завершение */
        $this->SetCode(rcOk);

        return $this;
    }



    /*
    Чтение контента
    */
    public function &Build()
    {
        /* List of conditions */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $ID = $this->GetIncome('ID', '');

        /* Создание дескрипта */
        $d = new TDescript();
        $r = $d->Read($ID, $IDSite);
        if ($r==rcOk)
        {
            $this->SetOutcome('Caption', $d->GetLang($IDLang, 'Caption', $ID));
            $this->SetOutcome('Content', $d->ContentRead($IDLang, $IDSite));
            $this->SetOutcome('DTActual', $d->Get('DTActual',''));
            $this->SetOutcome('Indexate', $d->Get('Indexate', $ID));
        }
        unset($d);

        return $this;
    }



    /*
    Чтение контента
    */
    public function &Content()
    {
        /* List of conditions */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $ID = $this->GetIncome('ID', '');

        /* Создание дескрипта */
        $d = new TDescript();
        $d->Assign($ID, '', $IDSite);
        $Result = $d->ContentRead($IDSite);
        unset($d);
        $this->SetContent($Result);
        $this->SetCode(rcOk);
        return $this;
    }
}
