<?php
/******************************************************************************
Catlair PHP Copyright (C) 2019  a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

24.09.2019 - still@itserv.ru
*/


class TConfig
{
    function  __construct()
    {
        $this->FParams = (object)[];
        $this->FFile = '';
        $this->FCode = rcUnknown;
        $this->FMessage = '';
    }



    /*
    Set file
    */
    public function &SetFile($AValue)
    {
        $this->FFile = $AValue;
        return $this;
    }



    /*
    Return file
    */
    public function GetFile()
    {
        return $this->FFile;
    }



    /*
    Return params
    */
    public function &GetParams()
    {
        return $this->FParams;
    }



    /*
    Read Config to object
    */
    public function &Read()
    {
         /* Read JSON to file */
         if (file_exists($this->FFile))
         {
             $Content = file_get_contents($this->FFile);
             $this->FParams = json_decode($Content);
             if ($this->FParams) $this->SetResult(rcOk,'');
             else $this->SetResult('ReadConfigError', $this->FFile);
         }
         else $this->SetResult('ConfigNotExists', $this->FFile);
         return $this;
    }



    public function &Flush()
    {
          /* Create filepath */
          $FilePath = dirname($this->FFile);
          if (!file_exists($FilePath)) mkdir($FilePath, FILE_RIGHT, true);

          /* Write JSON to file */
          $Content = json_encode($this->FParams);
          if (file_put_contents($this->FFile, $Content)) $this->SetResult(rcOk,'');
          else
          {
              $this->SetResult('ErrorStoreDatabaseConfig', $AFileName);
          }
          /* Return result */
          return $this;
     }



     public function &SetResult($ACode, $AMessage)
     {
        $this->FCode = $ACode;
        $this->FMessage = $AMessage;
        return $this;
     }



     public function IsOk()
     {
        return $this->FCode == rcOk;
     }



     public function GetResultCode()
     {
        return $this->FCode;
     }



     public function GetResultMessage()
     {
        return $this->FMessage;
     }
}
