<?php
/**

Catlair PHP Copyright (C) 2019  a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.


Catlair.
The webserver must start this file.
12.01.2019 still@itserv.ru

*/

define ('ROOT', __DIR__);

/* Core library */
include_once ROOT.'/core/utils.php';
include_once ROOT.'/core/debug.php';
include_once ROOT.'/core/cli_util.php';

/**/
include_once ROOT.'/cms/cms.php';
include_once ROOT.'/cms/session.php';
include_once ROOT.'/debug_utils.php';
include_once ROOT.'/descript.php';
include_once ROOT.'/descripts.php';
include_once ROOT.'/search.php';
include_once ROOT.'/language.php';
include_once ROOT.'/moment.php';
include_once ROOT.'/pay.php';

/* Descripts library */
include_once ROOT.'/domain.php';
include_once ROOT.'/site.php';
include_once ROOT.'/file.php';
include_once ROOT.'/account.php';

/* Start code */
$CMS = new TCMS();
$clLoger = $CMS; /* This line for old calls. It can be remove. */

/* Set path for log */
switch (php_sapi_name())
{
    case 'cgi':
    case 'fpm-fcgi':
        $CMS->SetDestination(TLog::FILE);
        $CMS->SetLogPath(clRootPath().'/log/'.$_SERVER['HTTP_HOST']);
        $CMS->SetLogFile($_SERVER['REQUEST_URI']);
    break;
    case 'cli':
        $CMS->SetDestination(TLog::CONSOLE);
    break;
}

/* New session object */
$clSession = new TSession($CMS);
$clSession->Open(false);
$CMS->SetSession($clSession);

/* Log begin */
$CMS->Start($clSession->Get('LogEnabled', true));
$CMS->Debug()->Text(TLog::LINE);
$CMS->Debug()->Text('Log start');
$CMS->Debug()->Text(TLog::LINE);
$CMS->BeginLabel('Start content builder');

$CMS->ContentBuild();

$clSession->Flush(); /* Save session data for next use */
$CMS->End();
$CMS->Stop();/* It is have ended log file */
