<?php
/**
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
* 18.09.2019 - still@itserv.ru
*
*/

include_once "debug.php";

/**
Return parameter for CLI mode by name $AKey:string from command line in full format [--name=vale]
or STDIN over $ALog:TLog with caption $ACaption:string.
If parameter not found, it will return $ADefault:string.
*/
function GetIncomeCLI($AKey, $ACaption, $ADefault, $ALog)
{
    $Values = getopt(null, [$AKey.':']);
    if (array_key_exists($AKey, $Values)) $Result = $Values[$AKey];
    else $Result = $ALog->Debug()->Text($ACaption)->Param($AKey, $ADefault)->Dialog($ADefault);
    return $Result;
}
