<?php

/**********************************************************************************
 * Catlair PHP
 * Copyright (C) 2019 a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 **********************************************************************************
 *
 * Work with date & time moment.
 *
 * For example return current DateTime in string format:
 *      $Moment = new TMoment();
 *      $Moment->Now()->Inc(CL_DAY)->ToString();
 *
 **********************************************************************************
 * chiv, still
 */


/* Constants time interval */
define("CL_MICRO_SECOND",  1);
define("CL_MILI_SECOND",  CL_MICRO_SECOND*1000);
define("CL_SECOND", CL_MILI_SECOND*1000);
define("CL_MINUTE",  CL_SECOND*60);
define("CL_HOUR",  CL_MINUTE*60);
define("CL_DAY",  CL_HOUR * 24);
define("CL_MONTH",  CL_DAY * 30);
define("CL_YEAR",  CL_DAY * 365);

/* Constants result of comparing */
define("CL_MORE",  1);
define("CL_LESS",  -1);
define("CL_EQUAL",  0);



/* Constructor */
class TMoment
{
    private $Moment;

    function __construct()
    {
        $this->Moment = 0;
    }



    /*
     * This moment return current value
     */
    public function Get()
    {
        return $this->Moment;
    }



    /*
     * This moment set to value
     */
    public function Set($AValue)
    {
        $this->Moment=(float)$AValue;
        return $this;
    }



    /*
     * Add
     */
    public function Add($AInterval)
    {
        $this->Moment+=$AInterval;
        return $this;
    }



    /*
     * Decrise this moment
     */
    public function Dec($AInterval)
    {
        $this->Moment-=$AInterval;
        return $this;
    }



    /*
     * This moment compare with $AMoment
     * Return CL_MORE, CL_LESS, CL_EQUAL
     */
    public function Compare(&$AMoment)
    {
        if ($this->Moment > $AMoment->Moment) return CL_MORE;
        else if ($this->Moment < $AMoment->Moment) return CL_LESS;
            else return CL_EQUAL;
    }



    /*
     * Object compare with now
     * Return CL_MORE, CL_LESS, CL_EQUAL
     */
    public function CompareNow()
    {
        $Now = microtime(true)*1000000;
        if ($this->Moment > $Now) return CL_MORE;
        else if ($this->Moment < $Now) return CL_LESS;
            else return CL_EQUAL;
    }



    /*
     * Object set to now
     */
    public function Now()
    {
        $this -> Moment = microtime(true) * 1000000;
        return $this;
    }



    /*
     * Convert moment to string with $AFormat
     */
    public function ToString($AFormat)
    {
        if (!$AFormat || $AFormat === null || $AFormat == '') $AFormat='Y-m-d H:i:s';
        return date($AFormat,$this->Moment/CL_SECOND);
    }



    /*
     * From string
     */
    public function FromString($AData)
    {
        $t=strtotime($AData);
        if ($t) $this->Moment=$t * CL_SECOND;
        return $this;
    }

}



/*
 * Fast functions
 */

function clNowToString($AFormat)
{
    $Now = new TMoment();
    $Now->Now();
    return $Now->ToString($AFormat);
    unset($Now);
}

