<?php
/******************************************************************************
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
******************************************************************************
* Content menegment system (CMS) for Catlair PHP
* Enterance point ContentBuild().
* still@itserv.ru
*/

/* Descripts library */
include_once ROOT."/core/builder.php";
include_once ROOT."/core/debug.php";
include_once ROOT."/core/config.php";
include_once ROOT."/cms/cms_utils.php";
include_once ROOT."/cms/cms_controller.php";
include_once ROOT."/datasource/data_factory.php";



class TCMS extends TBuilder
{
    /* */
    private $FFavicon = '';
    private $FTitle = '';
    private $FSession = null;
    private $FDataFactory = null;

    /* Datasource params*/
    private $FDatasource = null;
    private $FDatasourceName = null;
    private $FDatasourceType =null;
    private $FDatasourceHost =null;
    private $FDatasourceLogin =null;


    function __construct()
    {
        $this->FDataFactory = new TDataFactory($this);
        $this->FDatasourceList = []; /* Array of datasource */
    }


    /* Override Procedure Content */
    public function ExtContent($AID)
    {
        /* Get params */
        $IDSite = $this->FSession->GetSite();
        $IDLang = clGetLang(null);
        /* Get content */
        $Content = clDescriptContentByID($AID, $IDSite, $IDLang);
        /* Return result */
        return ['Content'=>$Content, 'Error'=>'', 'Message'=>''];
    }



    /* Override function Include path*/
    public function ExtIncludePath($APath, $AType)
    {
        /*Get params*/
        $IDSite = $this->FSession->GetSite();
        /* Build library name*/
        switch ($AType)
        {
            default: $FileName = clLibraryFileAny('public/' . $APath . '_public',  $IDSite);
            break;
            case 'controller': $FileName = clLibraryFileAny('controller/' . $APath,  $IDSite);
            break;
        }
        /* Return result  */
        return ['Path'=>$FileName, 'Continue'=>($APath != '%library%'), 'Error'=>'', 'Message'=>''];
    }



    /*
    Return TSession
    */
    public function GetSession()
    {
        return $this->FSession;
    }



    /*
    Set session $AValue:TSession
    */
    public function SetSession($AValue)
    {
        $this->FSession = $AValue;
        return $this;
    }



    public function ExtFunctionName($AName)
    {
        return ['Name'=>$AName.'Public','Error'=>'','Message'=>''];
    }



    /* Chouse the domain name from income params */
    public function GetDomain()
    {
        $Result = clGetIncome('dmn', null, DOMAIN_UNKNOWN);
        if ($Result === DOMAIN_UNKNOWN)
        {
            $Result = $this->FSession->Get('Domain', DOMAIN_UNKNOWN); /* Get domain name from session */
            if ($Result === DOMAIN_UNKNOWN && array_key_exists('HTTP_HOST', $_SERVER))
            {
                $Result = $_SERVER['HTTP_HOST']; /* Get domain name from HTTP_HOST */
            }
        }
        return trim($Result);
    }


    /*
    Return languager or $ADefault:string
    Language will return from (POST after GET) or (CLI) after (Sesion) after (Default) after LANG_DEFAULT.
    */
    public function GetLang($ADefault)
    {
        /*POST after URL*/
        $Result = clGetIncome('IDLang', null, LANG_UNKNOWN);
        if ($Result == LANG_UNKNOWN)
        {
            /*From session */
            $Result = $this->FSession->GetLanguage();
            if ($Result == LANG_UNKNOWN)
            {
                /* From default */
                $Result = $ADefault;
                if ($Result == null || $Result == LANG_UNKNOWN)
                {
                    /* Default*/
                    $Result = LANG_DEFAULT;
                }
            }
        }
        return $Result;
    }




    /*
     Build content
    */
    public function ContentBuild()
    {
        /* Set default params */
        $DefaultURL = '';
        $Start = '';
        $IDSite = SITE_UNKNOWN;
        $IDLang = LANG_DEFAULT;

        /* Check domain */
        $IDDomain = $this->GetDomain();
        $Params = SiteParamsByDomain($IDDomain);
        if ($Params!=null)
        {
            /* Site defined by domain */
            $IDLang = $this->GetLang($Params->IDLang); /* Get language */
            $IDSite = $Params->IDSite;
            $Start = $Params->IDContentStart;
            $DefaultURL = urldecode($Params->DefaultURL);
        }
        else
        {
            /* Site did not define by domain */
            $DefaultURL = '&body=404.html';
            $Start = 'Error.html';
        }

        /* Store to session  */
        $this->FSession->SetDomain($IDDomain);
        $this->FSession->SetSite($IDSite);
        $this->FSession->SetLanguage($IDLang);

        /* Read config data from site object if site is found*/
        if ($IDSite != SITE_UNKNOWN)
        {
            $Site = new TDescript();
            if ($Site->Read($IDSite, $IDSite) == rcOk)
            {
                /* Установка параметров сайта */
                $this->FFavicon = $Site->GetIDImage('DEFAULT_FAVICON');
                $this->FTitle = $Site->GetLang($IDLang, 'Caption', 'Default title');
                /* Установка параметров логирования */
                $this->FSession->Set('LogEnabled', $Site->GetArrayValue('Post','LogEnabled','off') == 'on');
                $this->FSession->Set('LogInfo',  $Site->GetArrayValue('Post','LogInfo','off') == 'on');
                $this->FSession->Set('LogDebug',  $Site->GetArrayValue('Post','LogDebug','off') == 'on');
                $this->FSession->Set('LogWarning', $Site->GetArrayValue('Post','LogWarning','off') == 'on');
                $this->FSession->Set('LogError', $Site->GetArrayValue('Post','LogError','off') == 'on');
                $this->FSession->Set('LogJob', $Site->GetArrayValue('Post','LogJob','off') == 'on');
            }
            unset($Site);
        }

        /* It is add GET params from $DefaultURL */
        parse_str($DefaultURL, $URL);
        foreach ($URL as $Key => $Value) if (!array_key_exists($Key, $_GET) && $Key!='?') $_GET[$Key] = $Value;


        $SAPI = php_sapi_name();
        /* Dump parameters */
        $this->Debug()->Param('SAPI', $SAPI);
        $this->Debug()->Param('IDDomain', $IDDomain);
        $this->Debug()->Param('IDSite', $IDSite);
        $this->Debug()->Param('IDLanguage', $IDLang);

        switch ($SAPI)
        {
            case 'cgi':
            case 'fpm-fcgi':
                /* Dump debug information */
                $this->Dump($_SERVER);
                $this->Dump($_COOKIE);
                $this->Dump($_GET);
                $this->Dump($_POST);
            break;
            case 'cli':
                /* Dump debug information */
                $this->Info()->Text('Server')->Dump($_SERVER);
            break;
            default:
                $this->Error()->Param('Unknown SAPI name', SAPI);
            break;
        }


        /* Build replace list */
        foreach ($_GET as $Key => $Value) $this->AddKey('%'.$Key.'%', $Value); /*  параметры из GET */
        foreach ($_POST as $Key => $Value) $this->AddKey('%'.$Key.'%', $Value); /* параметры из POST */
        $this->AddKey('%Title%', $this->FTitle);
        $this->AddKey('%Favicon%', $this->FFavicon);


        /* Begin processing */
        $Content = '';
        $Result = rcUnknown;


        /* Call controller */
        $Call = clGetIncome('call', null, null);
        if ($Result==rcUnknown && $Call!==null)
        {
            /* Call controller */
            $r=[];
            $this->LoadController($Call, $r);
            $this->Dump($r);
            if ($r['Error']=='')
            {
                $Controller = new $r['Class']($this);
                $this->BeginLabel($Call);
                call_user_func(array($Controller, $r['Method']));
                $this->End();
                $this->SetContent($Controller->End());
                unset($Controller);
                $Result = rcOk;
            }
            else
            {
                $this->SetContent($this->HTMLError($r['Error'], $r['Message'], $Call));
                $Result = $this->HTMLError($r['Error'], $r['Message'], $Call);
            }
        }



        /* Exec */
        $Exec = clGetIncome('exec', null, null);
        if ($Result ==rcUnknown && $Exec !==null)
        {
            /* Include library from URL */
            if (array_key_exists ('include', $_GET))
            {
                $this->BeginLabel('Include library');
                $PrefixLib = $_GET['include'];
                $FileName = clLibraryFileAny('public/' . $PrefixLib . '_public',  $IDSite);
                if ($FileName && file_exists($FileName)) include_once ($FileName);
                $this->End();
            }

            /* Public functions from exec */
            $this->BeginLabel('Exec');
            $NameFunc = $Exec.'Public';
            $Params = [];
            $Controller = new TController($this);
            if (function_exists($NameFunc))
            {
                call_user_func_array($NameFunc, array($Params, $Controller));
                $Result = rcOk;
            }
            else
            {
                $this->Error()->Param('Fuction not found', $FuncName);
                $Result = 'ExecFunctionNotFound';
            }
            unset($Controller);
            $this->End();
        }



        /* File */
        $File = clGetIncome('file', null, null);
        if ($Result == rcUnknown && $File !== null)
        {
            $f = new TFile();
            $Result = $f->Read($File, $IDSite);
            if ( $Result == rcOk ) $f->Send();
            unset($f);
        }



        /* Image */
        $Image = clGetIncome('image', null, null);
        if ($Result == rcUnknown && $Image !== null)
        {
            $f = new TFile();
            $Result = $f->Read($Image, $IDSite);
            if ($Result == rcOk) $f->SendImage();
            unset($f);
        }



        /*  Building content */
        if ($Result == rcUnknown)
        {
            if (array_key_exists ('template', $_GET)) $Start = $_GET['template'];
            $this->SetContent('<cl content="'.$Start.'"/>');
        }

        $this->Build()->Send();
        return $this;
    }



    public function &CreatePassword($AIDSite, $AResource, $ALength)
    {
        $Letter = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-!*#-_=';
        $l=strlen($Letter)-1;
        $Result = '';
        for ($i=0; $i<$ALength; $i++) $Result .= substr($Letter, rand(0,$l), 1);
        return $Result;
    }



    /*
    Store password
    */
    public function StorePassword($AIDSite, $AResource, $APassword)
    {
        $Path = clSitePath($AIDSite) . '/password';
        if (!file_exists($Path)) mkdir($Path, FILE_RIGHT, true);
        $Path = $Path . '/' . $AResource . '.json';
        $JSON = (object)[];
        $JSON->Password = $APassword;
        $JSON->DTUpdate = clNowToString(null);
        $Result = file_put_contents($Path, json_encode($JSON));
        if ($Result) $this->Debug();
        else $this->Warning();
        $this->Text('Store password')->Param('IDSite', $AIDSite)->Param('Resource',$AResource)->Param('Path',$Path);
        return $this;
    }



    /*
    Restore password
    */
    public function RestorePassword($AIDSite, $AResource)
    {
        $Path = clSitePath($AIDSite) . '/password/' . $AResource . '.json';
        $JSONString = file_get_contents($Path);
        $JSON = json_decode($JSON);
        if ($JSON && property_exists($JSON, 'Password')) $Result = $JSON->Password;
        else $$Result = false;
        return $Result;
    }



    /*
    Return Datasource config file
    */
    public function GetDatasourceConfig($AIDSite, $AName)
    {
        return clSitePath($AIDSite) . '/config/datasource/' . $AName . '.json';
    }



    /**
    Datasource initialization for site $AIDSite:string and name $AName:string
    */
    public function GetDatasource($AIDSite, $AName)
    {
        /* Set default result */
        $Result = null;
        /* Create key for datasource */
        $Link = $AIDSite.'_'.$AName;

        if (array_key_exists($Link, $this->FDatasourceList))
        {
            /* Return exists datasource from list */
            $Result = $this->FDatasourceList[$Link];
        }
        else
        {
            $File = $this->GetDatasourceConfig($AIDSite, $AName);
            $this->BeginLabel('Open datasource')->Param('Link', $Link)->Param('Config', $File);
            /* Open new datasource */
            $Config = new TConfig();
            $Config->SetFile($File)->Read();
            if ($Config->IsOk())
            {
                /*Get config params */
                $Params = $Config->GetParams();
                /* Include datasource library */
                include_once ROOT.'/datasource/data_factory.php';
                $Result = $this->FDataFactory->Create($Params->Type);
                if ($Result != null)
                {
                    /*Connect to database*/
                    $Result->SetHost($Params->Host)->SetLogin($Params->Login)->SetPassword($Params->Password)->SetDatabase($Params->Database);
                    $Result->Open();
                    $Result->DatabaseSelect();
                }
                /* put datasource in to list */
                $this->FDatasourceList[$Link] = $Result;
            }

            $this->End();
        }
        return $Result;
    }




     /*
     Возвращает родной для сайта или дефаултный датасоурс
     */
     private function GetDatasourceAny($AIDSite, $AName)
     {
         /* Проверка в родном датасоурсе для указанного сайта */
         $Result = $this->GetDatasource($AIDSite, $AName);
         /* Если родного датасоурса не существует пытаемся вернуть датасуорс для дефаултного сайта */
         if ($Result == null) $Result = $this->GetDatasource(SITE_DEFAULT);
         return $Result;
     }


    /**
    * Получение контента дескрипта по идентификатору
    */
    function clDescriptContentByID($AID, $IDSite, $AIDLang, $IDName)
    {
        $d = new TDescript();
//        $Result = $d->ReadExisting($AID, $IDSite);
//        if ($Result == rcOk) $Result = $d->ContentRead($AIDLang);
//        else $Result='{ID:"'.str_replace('%', '&#37;', htmlspecialchars($AID)) .'", Site:"'.$IDSite.'", Lang:"' . $AIDLang. '", Code:"' .$Result . '"}';
        unset($d);
        return $Result;
    }



    /**
    */
    public function GetDatafactory()
    {
        return $this->FDataFactory;
    }
}
