<?php

/**********************************************************************************
 * Catlair PHP
 * Copyright (C) 2019 a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 **********************************************************************************
 *
 * Library for Payment
 * - Payment information store
 * - PayPal verification interface
 */

/* Constant for PayPal Sandpox */
define('PROVIDER_PAYPAL_SANDBOX', 'PayPalSandBox');
define('URL_VERIFICATION_PAYPAL_SANDBOX', 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr?cmd=_notify-validate');

/* Constant for PayPal */
define('PROVIDER_PAYPAL', 'PayPal');
define('URL_VERIFICATION_PAYPAL', 'https://ipnpb.paypal.com/cgi-bin/webscr?cmd=_notify-validate');


class TPay
{
    /* Private declaration */
    private $IDSite = null; /* Site identify */
    private $IDPay = null; /* Payment identifer from provider*/
    private $PayParams = null; /* Params of payment from provider */
    private $Verification = false; /* Verification status */
    private $IDProvider = PROVIDER_PAYPAL_SANDBOX; /* Provider identify */

    /*
     * Constructor
     */
    function __construct()
    {
    }



    /*
     * Pay params from post
     */
    public function Init($AIDPay, $AIDProvider, $AIDSite)
    {
        clBeg("");
        $Result = rcUnknown;

        if ($this->IDPay != '') $Result='PayAlredyInitialized';
        else
        {
            switch ($AIDProvider)
            {
                case PROVIDER_PAYPAL:
                case PROVIDER_PAYPAL_SANDBOX:
                    foreach ($_POST as $key => $value) $this->PayParams[$key]=$value;
                    $Result = rcOk;
                break;
            }
        }

        if ($Result = rcOk)
        {
            $this->IDPay = $AIDPay;
            $this->IDSite = $AIDSite;
            $this->IDProvider = $AIDProvider;
        }

        clEnd("");
        return $Result;
    }



    /*
     * Object returns marker of verification true or false
     */
    public function GetVerification()
    {
        return $this->Verification;
    }



    /*
     * Verification process
     */
    public function ProcessVerification()
    {
        clBeg("");

        $Result = rcUnknown;
        switch ($this->IDProvider)
        {

            case PROVIDER_PAYPAL:
                /* URL for verification pay transaction */
                $URL = URL_VERIFICATION_PAYPAL . $this->ParamsToGetFormat();
                clDeb('Request URL ['.$URL.']');
                /* Request */
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $URL);
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $Answer = curl_exec($ch);
                curl_close($ch);
                clDeb('Answer ['.$Answer.']');
                /* Result verification VERIFIED or INVALID */
                $this->Verification = ($Answer == 'VERIFIED');
            break;

            case PROVIDER_PAYPAL_SANDBOX:
                /* URL for verification pay transaction */
                $URL = URL_VERIFICATION_PAYPAL_SANDBOX . $this->ParamsToGetFormat();
                clDeb('Request URL ['.$URL.']');
                /* Request */
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $URL);
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $Answer = curl_exec($ch);
                curl_close($ch);

                clDeb('Answer ['.$Answer.']');
                /* Result verification VERIFIED or INVALID */
                $this->Verification = ($Answer == 'VERIFIED');
            break;

        }
        if ($this->GetVerification()) $Result = rcOk;
        else $Result = 'NotVerified';

        clEnd($Result);
        return $Result;
    }



    /*
     * Save pay to file.
     */
    public function Flush()
    {
         clBeg('');
         $Result=rcOk;
         if ($Result==rcOk)
         {
             if ($this->IDPay==null || $this->IDPay=='') $Result='ErrorPayNotExists';
             else
             {
                if ($Result==rcOk)
                {
                    $File=clGetPayFileName($this->IDSite, $this->IDProvider, $this->IDPay);
                    clDeb('File ['.$File.']');
                    $Path=pathinfo($File, PATHINFO_DIRNAME);
                    if (!file_exists($Path) && !mkdir($Path, FILE_RIGHT, true)) $Result = 'ErrorCreatePayFolder';
                    $ObjectPay['Object']['IDPay']=$IDPay;
                    $ObjectPay['Object']['IDSite']=$IDSite;
                    $ObjectPay['Object']['Verification']=$Verification;
                    $ObjectPay['Object']['IDProvider']=$IDProvider;
                    $ObjectPay['PayParams']=$this->PayParams;
                    if ($Result==rcOk) file_put_contents($File, json_encode($ObjectPay));
                }
            }
        }
        clEnd($Result);
        return $Result;
    }



    /*
     * Pay params to get fromat
     */
    private function ParamsToGetFormat()
    {
        $Result='';
        foreach ($this->PayParams as $key => $value) $Result .= '&'.$key.'='.encodeURIComponent($value);
        return $Result;
    }
}



/**
 * Retun Pay Path by site
 */
function clGetPayPath($AIDSite)
{
    return  clSitePath($AIDSite) . '/pays';
}



/*
 * Return Full Name File by name
 *      $AIDSite - site identify
 *      $AProvider -
 */
function clGetPayFileName ($AIDSite, $AProvider, $AName)
{
    return clGetPayPath($AIDSite) . '/' . $AProvider . clScatterName($AName, 3, 'UTF-8').'.json';
}


