<?php
/******************************************************************************
 * Catlair PHP
 * CLI интерфейс
 * выпуск сайта и его сборка
 *
 * Параметры
 * - Маска файла контента (по умолчанию *)
 * - Идентификатор сайта (по умолчанию SITE_DEFAULT)
 * - Идентификатор языка (по умолчанию LANG_DEFAULT)
 *
 * still@itserv.ru
 */

include_once "core/utils.php";
include_once "core/debug.php";

include_once "cms/cms_utils.php";
include_once "descript_utils.php";

//include "debug_utils.php";
//include "result.php";
//include "descript.php";
//include "main.php";
//include "search.php";
//include "file.php";


$Log = new TLog();

$Log->Start(true); // start logger
$Log->Begin()->Text('Production begin');

// Get descript IT
if (count($argv)>1) $IDSiteSource = $argv[1];
else
{
        $Log->Info()->Text('Site source: [*]');
        $IDSiteSource = readline();
        if ($IDSiteSource=='') $IDSiteSource = SITE_DEFAULT;
}

if (count($argv)>2) $IDSiteDestination = $argv[2];
else
{
        $Log->Info()->Text('Site destination:');
        $IDSiteDestination = readline();
        if ($IDSiteDestination=='') $IDSiteDestination = null;
}


if (count($argv)>3) $HeaderFile = $argv[3];
else
{
        $Log->Info()->Info('Header file for PHP & JS:');
        $HeaderFile = readline();
        if ($HeaderFile=='') $HeaderFile = null;
}





// Check param login
if ($IDSiteDestination == null) $Log->Warning()->Text('Site destination not found');
else
{
    $SourcePath = clSitePath($IDSiteSource);
    $DestinationPath = clSitePath($IDSiteDestination);
    $Log->Debug()->Param('Source site path', $SourcePath);
    $Log->Debug()->Param('Destination site path', $DestinationPath);

    // Удаляем сайт направление
    if (file_exists($DestinationPath))
    {
        clDeleteFolder($DestinationPath);
        $Log->Debug()->Param('Destination site path', $DestinationPath);
    }

    if ($HeaderFile)
    if ($HeaderFile!=null) $HeaderContent = file_get_contents($HeaderFile);
    else $HeaderContent = '';

    /* Создание словаря */
    $Vocab =
    [
        ['Key'=>'<?'.'php', 'Value'=>'<?'.'php'.chr(10).$HeaderContent],

        ['Key'=>'SITE_DEFAULT', 'Value'=>'f'.MD5('SITE_DEFAULT')],
        ['Key'=>'LANG_DEFAULT', 'Value'=>'f'.MD5('LANG_DEFAULT')],
        ['Key'=>'TYPE_DEFAULT', 'Value'=>'f'.MD5('TYPE_DEFAULT')],
        ['Key'=>'BIND_DEFAULT', 'Value'=>'f'.MD5('BIND_DEFAULT')],
        ['Key'=>'rcOk', 'Value'=>'f'.MD5('rcOk')],
        ['Key'=>'rcUnknown', 'Value'=>'f'.MD5('rcUnknown')],

        ['Key'=>'Logger','Value'=>'f'.MD5('Logger')],
        ['Key'=>'clBeg', 'Value'=>'f'.MD5('clBeg')],
        ['Key'=>'clEnd', 'Value'=>'f'.MD5('clEnd')],
        ['Key'=>'clDeb', 'Value'=>'f'.MD5('clDeb')],
        ['Key'=>'clInf', 'Value'=>'f'.MD5('clInf')],
        ['Key'=>'clWar', 'Value'=>'f'.MD5('clWar')],
        ['Key'=>'clErr', 'Value'=>'f'.MD5('clErr')],
        ['Key'=>'clGetIncome', 'Value'=>'f'.MD5('clGetIncome')],
        ['Key'=>'HexToString', 'Value'=>'f'.MD5('HexToString')],
        ['Key'=>'StringToHex', 'Value'=>'f'.MD5('StringToHex')]
    ];



    /**
     * Обрабатываем php
     */
    $PHPVocab =
    [
        ['Key'=>'<?'.'php', 'Value'=>'<?'.'php'.chr(10).$HeaderContent]

//        ['Key'=>'SITE_DEFAULT', 'Value'=>'f'.MD5('SITE_DEFAULT')],
//        ['Key'=>'LANG_DEFAULT', 'Value'=>'f'.MD5('LANG_DEFAULT')],
//        ['Key'=>'TYPE_DEFAULT', 'Value'=>'f'.MD5('TYPE_DEFAULT')],
//        ['Key'=>'BIND_DEFAULT', 'Value'=>'f'.MD5('BIND_DEFAULT')],
//        ['Key'=>'rcOk', 'Value'=>'f'.MD5('rcOk')],
//        ['Key'=>'rcUnknown', 'Value'=>'f'.MD5('rcUnknown')],
//
//        ['Key'=>'Logger','Value'=>'f'.MD5('Logger')],
//        ['Key'=>'clBeg', 'Value'=>'f'.MD5('clBeg')],
//        ['Key'=>'clEnd', 'Value'=>'f'.MD5('clEnd')],
//        ['Key'=>'clDeb', 'Value'=>'f'.MD5('clDeb')],
//        ['Key'=>'clInf', 'Value'=>'f'.MD5('clInf')],
//        ['Key'=>'clWar', 'Value'=>'f'.MD5('clWar')],
//        ['Key'=>'clErr', 'Value'=>'f'.MD5('clErr')],
//        ['Key'=>'clGetIncome', 'Value'=>'f'.MD5('clGetIncome')],
//        ['Key'=>'HexToString', 'Value'=>'f'.MD5('HexToString')],
//        ['Key'=>'StringToHex', 'Value'=>'f'.MD5('StringToHex')]
    ];


    ProductionPHP('',$Log, $IDSiteSource, $IDSiteDestination, $PHPVocab);
    ProductionPHP('/public', $Log, $IDSiteSource, $IDSiteDestination, $PHPVocab);
    ProductionPHP('/cms', $Log, $IDSiteSource, $IDSiteDestination, $PHPVocab);
    ProductionPHP('/datasource', $Log, $IDSiteSource, $IDSiteDestination, $PHPVocab);
    ProductionPHP('/core', $Log, $IDSiteSource, $IDSiteDestination, $PHPVocab);
    ProductionPHP('/controller', $Log, $IDSiteSource, $IDSiteDestination, $PHPVocab);

    /**
     * Копируем дерево дескриптов
     */
    $Log->Begin()->Text('Descript copy');
    $Source = clDescriptsPath($IDSiteSource);
    $Dest = clDescriptsPath($IDSiteDestination);
    $Log->Debug()->Text('['.$Source.'] source descript path');
    $Log->Debug()->Text('['.$Dest.'] destination descript path');
    FileCopy($Source, $Dest);
    $Log->End();

   /**
    * Обрабатываем JS
    */
    $VocabJS =
    [
        ['Key'=>'TCatlair', 'Value'=>'js'.MD5('TCatlair')],
        ['Key'=>'Catlair', 'Value'=>'js'.MD5('Catlair')],
        ['Key'=>'catlair', 'Value'=>'js'.MD5('catlair')]
    ];


   $Log->Begin()->Text('Convert begin');
   {
       $SourcePath = clSitePath($IDSiteDestination);
       $FileMask = '/var/www/html/catlair/site/' . $IDSiteDestination . '/descripts/' . '*.js';
       $Log -> Begin() -> Param('FileMask',$FileMask);
       foreach (glob($FileMask) as $File)
       {
           $IDDescript = basename($File);
           $ContentFile = clDescriptContentFile( $IDSiteDestination, LANG_DEFAULT, $IDDescript);
           if (file_exists($ContentFile))
           {
                $Log -> Debug() -> Param('File', $ContentFile);
                $JSContent = file_get_contents($ContentFile);
                $JSContent = $HeaderContent . Obfus($JSContent, $VocabJS);
                file_put_contents($ContentFile, $JSContent);
           }
       }
       $Log->End();
   }
   $Log->End();

}
$Log->End()->Stop();




/* Обфурскация имен переменных */
function ConvertVar($AValue)
{
    if
    (
        $AValue[0]=='$clLoger' ||  // это потому что не фурсится cl.php надо принять меры.
        $AValue[0]=='$this' ||
        $AValue[0]=='$GLOBALS' ||
        $AValue[0]=='$_SERVER' ||
        $AValue[0]=='$_GET' ||
        $AValue[0]=='$_POST' ||
        $AValue[0]=='$_FILES' ||
        $AValue[0]=='$_COOKIE' ||
        $AValue[0]=='$_SESSION' ||
        $AValue[0]=='$_REQUEST' ||
        $AValue[0]=='$_ENV'
    ) $Result=$AValue[0];
    else $Result='$f'.MD5((string)$AValue[0]);
    $Log->Debug()->Text($AValue[0].' -> '.$Result);
    return $Result;
}



/* Обфурскация имен переменных */
function ConvertString($AValue)
{
    if ($AValue!='\'\'')
    {
        $s=StringToHex( substr($AValue[0], 1, -1));
        return 'HexToString(\'' . $s . '\')';
    }
    else return $AValue[0];
}



/* Обфурскатор */
function Obfus($ASource, $AVac)
{
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?:\/\/.*?(\n|$))/', '$1', $ASource); /* выкусывание однострочных коментариев */
    $ASource = preg_replace ('/(\'.*?\')|(?:\/\*(?:.|\n)*?\*\/)/', '$1', $ASource); /* выкусывание многострочных коментариев */
    $ASource = preg_replace ('/\s+?(\n)/', '$1', $ASource); /* все пробелы до конца строки */
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(=) ?)/', '$1$2', $ASource); /* убрать все пробелы вокруг = */
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(>) ?)/', '$1$2', $ASource);  // убрать все пробелы вокруг >
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(<) ?)/', '$1$2', $ASource);  // убрать все пробелы вокруг <
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\.) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг .
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(,) ?)/', '$1$2', $ASource);  // убрать все пробелы вокруг .
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\() ?)/', '$1$2', $ASource); // убрать все пробелы вокруг (
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\)) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг )
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\-) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг -
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\+) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг +
    $ASource = preg_replace ('/\n/', ' ', $ASource); // Косим все энтеры
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?:( ) +)/', '$1$2', $ASource); // Косим двойные пробелы
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\{) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг {
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\}) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг }
    $ASource = preg_replace ('/(\'(?:.|\n)*?\')|(?: ?(\;) ?)/', '$1$2', $ASource); // убрать все пробелы вокруг ;

//    $ASource = preg_replace_callback ('/\'(?:.|\n)*?\'/', 'ConvertString', $ASource); /* конвертим строки в хекс */
//    $ASource = preg_replace_callback ('/\$\w+/', 'ConvertVar', $ASource); /* превращаем переменнные в мусор */

    // Подмены словаря
    if ($AVac!=null)
    {
        foreach ($AVac as $Line) $ASource = str_replace ($Line['Key'], $Line['Value'], $ASource);
    }
    return $ASource;
}




/**
 * Обрабатываем php
 */

function ProductionPHP($APath, $ALog, $IDSiteSource, $IDSiteDestination, $APHPVocab)
{
    $SourcePath = clSitePath($IDSiteSource);
    $DestinationPath = clSitePath($IDSiteDestination);

    $ALog->Begin()->Debug()->Text($APath);
    {
        $LibrarySourcePath = clLibraryPath($IDSiteSource).$APath;
        $LibraryDestinationPath = clLibraryPath($IDSiteDestination).$APath;

        $ALog->Debug()->Param('Source site path', $LibrarySourcePath);
        $ALog->Debug()->Param('Destination site path', $LibraryDestinationPath);

        /* Создаем папку скиптов */
        if (!file_exists($LibraryDestinationPath)) mkdir($LibraryDestinationPath, FILE_RIGHT, true);

        if (file_exists($LibraryDestinationPath) && file_exists($LibrarySourcePath))
        {
            /* Обход файлов скриптов */
            $Files = array_diff(scandir($LibrarySourcePath), array('.', '..'));
            foreach ($Files as $File)
            {
                if (pathinfo($File, PATHINFO_EXTENSION) == 'php')
                {
                    $ALog->Begin()->Debug()->Text($File);
                    $Content = file_get_contents($LibrarySourcePath.'/'.$File);
                    $Content = Obfus($Content, $APHPVocab);
                    file_put_contents($LibraryDestinationPath.'/'.$File, $Content);
                    $ALog->End();
                }
            }
        }
    }
    $ALog->End();
}
