<?php

/**
 * Catlair PHP
 * Пользовательские публичные функции
 * still@itserv.ru
 */



function clStorageFilePath($AIDSite)
{
    $Result = clSitePath($AIDSite) . '/exchange';
    return $Result;
}


/*
 * Get file group
 */
function FileGroupPublic($AParams, $AResult)
{
    Logger()->Begin();
    global $clSession;
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $IDGroup = clGUID();
    $AResult->Set('IDGroup', $IDGroup);
    $AResult->SetCode(rcOk);
    Logger()->End();
    return true;
}



/*
 * Пользовательское создание новго дескрипта из формы
 */
function FileUploadPublic($AParams, $AResult)
{
    Logger()->Begin();

    global $clSession;
    /* Получение параметров */
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $IDGroup = clGetIncome('IDGroup', $AParams, null);

    Logger()->Debug()->Param('Received files', count($_FILES))->Param('IDSite',$IDSite)->Param('IDGroup', $IDGroup);

    $Path = clStorageFilePath($IDSite).'/'.$IDGroup;
    Logger()->Debug()->Param('Path',$Path);

    /* Валидация имени */
    $Result = clDescriptIDValidate($IDGroup);

    if ($Result == rcOk)
    {
        /* Create directory */
        if (file_exists($Path)) $Result=rcOk;
        else
        {
            if (mkdir($Path, FILE_RIGHT, true)) $Result=rcOk;
            else $Result = 'ErrorCreateGroupFolder';
        }
        /* Загрузка файлов */
        foreach ($_FILES as $File)
        {
            if ($Result == rcOk)
            {
                $Destination = $Path . '/' . $File['name'];
                if (move_uploaded_file($File['tmp_name'], $Destination)) $Result=rcOk;
                else $Result = 'ErrorMoveUploadedFile';
            }
        }
    }

    /* обработка резульата */
    $AResult->SetCode($Result);
    Logger()->End()->Text($Result);
    return true;
}



function FileDownloadListPublic($AParams, $AResult)
{
    Logger()->Begin();

    /* Получение параметров */
    global $clSession;
    $IDLang = clGetLang(clGetIncome('IDLang', $AParams, null));
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $IDGroup = clGetIncome('IDGroup', $AParams, null);
    $IDRecord = clGetIncome('IDRecord', $AParams, null);

    Logger()->Debug()->Param('Received files', count($_FILES))->Param('IDSite',$IDSite)->Param('IDGroup', $IDGroup);

    $Result = clDescriptIDValidate($IDGroup);
    if ($Result==rcOk)
    {
        $Path = clStorageFilePath($IDSite).'/'.$IDGroup;
        Logger()->Debug()->Param('Path', $Path);

        $Descripts = new TDescripts();
        $List = scandir($Path);

        /* Build records */
        foreach($List as $FileName)
        {
            if ($FileName!='.' && $FileName!='..')
            {
                $FilePath = $Path.'/'.$FileName;
                $FileSize = clSizeToStr(filesize($FilePath),'0');
                $Record=['FileName'=>$FileName, 'FileSize'=>$FileSize];
                $Descripts->Insert($Record);
            }
        }

        /* Return records*/
        $RecordContent = clDescriptContentByID($IDRecord, $IDSite, $IDLang);
        $AResult->SetContent($Descripts->BuildContent($RecordContent, 2));

        /* Return records*/
        $Descripts->BuildResult($AResult, 'Records');
        $AResult->SetCode(rcOk);
        unset($Descript);
    }
    Logger()->End()->Text($Result);
    return true;
}


function FileDownloadPublic($AParams, $AResult)
{
    Logger()->Begin();

    /* Получение параметров */
    global $clSession;
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $IDGroup = clGetIncome('IDGroup', $AParams, null);
    $IDFile = clGetIncome('IDFile', $AParams, null);

    $Result = clDescriptIDValidate($IDGroup);
    if ($Result == rcOk)
    {
        $Result = clDescriptIDValidate($IDFile);
        if ($Result==rcOk)
        {
            $File = clStorageFilePath($IDSite).'/'.$IDGroup.'/'.$IDFile;
            clSendFile($IDFile, $File);
        }
    }

    Logger()->End()->Text($Result);
    return true;
}
