<?php

/**************************************************************************************
 * Catlair PHP Copyright (C) 2019  a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 ******************************************************************************
 *
 * User's public function for TTask
 * 06.06.2019
 *
 ******************************************************************************
 *
 * still@itserv.ru
 *
 */

/**
 * Public function buid tasks list.
 */
function TaskLoadPublic($AParams, $AResult)
{
    clBeg('');
    global $clSession;

    /*List of conditions*/
    $IDLang = clGetLang(clGetIncome('IDLang', $AParams, null));
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $ID = clGetIncome('ID', $AParams, null);
    $IDType = 'Task';
    $RecordCurrent = clGetIncome('RecordCurrent', $AParams, 0);
    $RecordCount = clGetIncome('RecordCount', $AParams, 5);
    $IDParent = clGetIncome('IDParent', $AParams, null);
    $IDBind = clGetIncome('IDBind', $AParams, BIND_DEFAULT);

    /* Create find string */
    $Find = rawurldecode(clGetIncome('Find', $AParams, ''));
    if ($ID!=null) $Find .= ' ' . clIndexIDString($ID);
    if ($IDType!=null) $Find .= ' ' . clIndexTypeString($IDType);
    $Find = trim($Find);

    /* Build records by findstring */
    $Descripts = new TDescripts();
    $Descripts->LoadFromIndex($IDSite, $IDLang, $Find, $IDParent, $IDBind);

    /* Get total records */
    $AResult->SetGroup('Records', 'RecordTotal', $Descripts->RecordCount());

    /* Get descripts data */
    $Descripts->SelectDescript($IDSite, $IDLang, 'ID', $IDBind);

    /* Get specific params */
    $Descripts->SelectDescriptArray($IDSite, 'ID', 'Post', ['IDStatus', 'IDPriority']);

    /* Sorting */
    function TaskOrder($a,$b)
    {
        $Direct = 1;
        /* get parameters*/
        $StatusA = StatusToIndex($a['IDStatus']);
        $StatusB = StatusToIndex($b['IDStatus']);
        $PriorityA = PriorityToIndex($a['IDPriority']);
        $PriorityB = PriorityToIndex($b['IDPriority']);
        /* sort conditions */
        if ($StatusA > $StatusB) return $Direct;
        else if ($StatusA < $StatusB) return -$Direct;
            if ($PriorityA > $PriorityB) return -$Direct;
            else if ($PriorityA < $PriorityB) return $Direct;
                if ($a['DTInsert'] > $b['DTInsert']) return $Direct;
                else if ($a['DTInsert'] < $b['DTInsert']) return -$Direct;
                    else return 0;
    }
    usort($Descripts->Array, 'TaskOrder');

    /* Paging */
    $Descripts->Cut($RecordCurrent, $RecordCount);

    /* Select status attributes */
    $Descripts->SelectDescriptFields
    (
        $IDSite, $IDLang, 'IDStatus',
        [
            'Caption'=>'CaptionStatus',
            'IDImage'=>'IDImageStatus',
            'ARGBHEX'=>'ARGBHEXStatus'
        ]
    );

    /* Select priority attributes */
    $Descripts->SelectDescriptFields
    (
        $IDSite, $IDLang, 'IDPriority',
        [
            'Caption'=>'CaptionPriority',
            'IDImage'=>'IDImagePriority'
        ]
    );

    /* Set record current */
    $AResult->SetGroup('Records', 'RecordCurrent', $RecordCurrent+$Descripts->RecordCount());

    /* Return records*/
    $Descripts->BuildResult($AResult, 'Records');
    unset($Descript);

    /* End */
    $AResult->SetCode(rcOk);
    clEnd('');
    return true;
}



/*
 * Return numeric index by status
 */
function StatusToIndex($AStatus)
{
    switch ($AStatus)
    {
        case 'StatusNew': return 1;
        case 'StatusWait': return 2;
        case 'StatusWork': return 3;
        case 'StatusControl': return 4;
        case 'StatusClose': return 5;
        case 'StatusCancel': return 6;
    }
}



/*
 * Return priority index by status
 */
function PriorityToIndex($APriority)
{
    switch ($APriority)
    {
        case 'PriorityLow': return -1;
        case 'PriorityNormal': return 0;
        case 'PriorityHi': return 1;
    }
}
