<?php
/******************************************************************************
 * Catlair PHP
 * Copyright (C) 2019 a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * CLI интерфейс
 * Change password for accounts
 * php /var/www/html/catlair/site/site_default/php/account_token_create_cli.php lab chiv
 */

include "core/debug.php";
include "core/utils.php";

include "debug_utils.php";
include "result.php";
include "descript.php";
include "main.php";
include "search.php";
include "moment.php";

include "account.php";

$clLoger->Start(true); // start logger

clBeg('Create token for account');

/* Get site */
if (count($argv)>1) $Site = $argv[1];
else
{
        clInf('Site ['.SITE_DEFAULT.']: ');
        $Site = readline();
        if ($Site=='') $Site = SITE_DEFAULT;
}

/* Get IDAccount*/
if (count($argv)>2) $IDAccount = $argv[2];
else
{
        clInf('Account: ');
        $IDAccount = readline();
}


/* Check param login */
if ($IDAccount == '') $Result = 'Account empty';
else
{
    $d = new TAccount();
    $Result = $d->Read($IDAccount, $Site);
    if ($Result == rcOk)
    {
        $Result = $d->TokenCreate();
        if ($Result == rcOk) $Result = $d->TokenFlush();
    }
    unset($d);
}
clEnd($Result);
$clLoger->Stop();
