<?php
/**
Catlair PHP
Copyright (C) 2019 a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

class Domain extends TCMSController
{
    /*
    Создание учетной записи для сайта
    */
    public function &Create()
    {
        /* List of conditions */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $IDDomain = $this->GetIncome('IDDomain', 'localhost');

        if ($this->GetBuilder()->GetSession()->IsGuest()) $Result = 'SessionIsNotAuth';
        else
        {
            $Site = new TDescript();
            $Result = $Site->Read($IDSite, $IDSite);
            if ($Result!=rcOk) $Result = 'SiteNotFound';
            else
            {
                if ($IDDomain == '') $Result = 'LoginNotFound';
                else
                {
                    if (clDescriptExists($IDSite, $IDDomain)) $Result = 'DomainExists';
                    else
                    {
                        $Domain = new TDomain();
                        $Domain->Create($IDDomain, TYPE_DOMAIN, $IDSite);
                        $Domain->SetLang($IDLang, 'Caption', $IDDomain);

                        $Result = $Domain->BindBegin($Site);
                        $Result = $Domain->Bind($Site, BIND_DEFAULT, false);
                        $Result = $Domain->Bind($Site, BIND_RIGHT, false);
                        $Result = $Domain->BindEnd($Site);

                        if ($Result == rcOk)
                        {
                            $Result = $Domain->Flush();
                            if ($Result==rcOk)
                            {
                                $Post=['IDSiteTarget'=>$IDSite, 'IDContentStart'=>'Main.html', 'DefaultURL'=>'&page=Page.html&body=Body.html'];
                                $Result = $Domain->ArrayStore('Post', $Post);
                                if ($Result==rcOk)
                                {
                                    $this->Set('IDSite', $IDSite);
                                    $this->Set('IDDomain', $IDDomain);
                                }
                            }
                        }

                        unset($Domain);
                    }
                }
            }
            unset($Site);
        }

        $this->SetCode($Result);
        return $this;
    }
}

