<?php
/******************************************************************************
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/


include_once ROOT."/datasource/datacore.php";
include_once ROOT."/datasource/data_factory.php";


class TDefault extends TDataCore
{
    function __construct($ALog)
    {
        parent::__construct($ALog);
        $this->SetType(TDataFactory::DEFAULT);
    }



    public function NativeToUniConverting($ANative)
    {
        $Result = TDataCore::UNKNOWN;
        return $Result;
    }



    public function UniToNativeConverting($AUni)
    {
        $Result = $AUni;
        return $Result;
    }



    public function Opening()
    {
        return true;
    }



    /*
    Disconnect from mysql
    */
    public function Closing()
    {
        return true;
    }



    /*
    Return true if database $ADatabase:string exists
    */
    public function DatabaseExisting($ADatabase)
    {
        return true;
    }



    /*
    Database $ADatabase:string create for mysql.
    Calling from TDatasource->DatabaseCreate.
    Return $this.
    */
    public function DatabaseCreating($ADatabase)
    {
        return $this;
    }



    /*
    Database $ADatabase:string deleting for mysql.
    Calling from TDatasource->DatabaseDelete.
    Return $this.
    */
    public function DatabaseDeleting($ADatabase)
    {
        return $this;
    }



    /*
    Selet database $ADatabase:string
    */
    public function DatabaseSelecting($ADatabase)
    {
        return $this;
    }



    /*
    Creating database administrator $ADatabase:string
    */
    public function DatabaseAdminCreating($ALogin, $APassword)
    {
        return $this;
    }




    /*
    Table creating
    */
    public function TableCreating($ATable, $AFields, $AIndexes)
    {
        return $this;
    }



    /*
    Table creating
    */
    public function &FieldCreating($ATable, $AField)
    {
        return $this;
    }



    /*
    */
    public function UserExisting($ALogin, $AHost)
    {
        return true;
    }



    /*
    */
    public function &UserDeleting($ALogin, $AHost)
    {
        return $this;
    }



    /*
    Specific INSERT action for this Datasource
    */
    public function Inserting($ATableName, $AParams)
    {
        return mysqli_insert_id($this->FHandle);
    }



    /*
    Specific UPDATE action for this Datasource
    */
    public function Updating($ATableName, $AConditions, $AValues)
    {
        return $this;
    }




    public function Deleting($ATableName, $AParams)
    {
        return $this;
    }




    /*
    Specific SELECT action for this Datasource
    */
    public function &Selecting($ATableName, $AParams)
    {
       return $this;
    }



    /*
    Specific Calling action for this Datasource
    */
    public function &Calling()
    {
       return $this;
    }



    /*
    Specific SELECT action for this Datasource
    */
    public function Reading()
    {
       return true;
    }



    /*
    Finalize any interaction and datamanipulation with datasource.
    Can call after Select Delete Update Insert Exec and other.
    */
    public function Finalizing()
    {
    }



    public function Next()
    {
        return true;
    }



    /*
    */
    private function GetSpecificResultCode()
    {
        return rcOk;
    }



    /* Create Field params from array*/
    public function CmdFieldCreate($AField)
    {
        return '';
    }
}
