<?php

/******************************************************************************
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
******************************************************************************
*
* Content menegment system (CMS) for Catlair PHP
* Enterance point ContentBuild().
* still@itserv.ru
*/

define("XML_HEADER",   '<?xml version="1.0" encoding="UTF-8"?>'); // заголовок xml для всех операций

define("LANG_DEFAULT", 'language_ru'); // идентификатор умолчального языка
define("LANG_UNKNOWN", 'language_unknown'); // идентификатор умолчального языка

define("TYPE_UNKNOWN", 'Unknown'); // неопределенный идентификатор дескрипта
define("TYPE_DEFAULT", 'Descript'); // умолчальный идентификатор дескрипта
define("TYPE_SITE",    'Site'); // умолчальный идентификатор дескрипта
define("TYPE_DOMAIN",  'Domain'); // умолчальный идентификатор дескрипта

define("SITE_DEFAULT", 'site_default'); // идентификатор умолчального сайта
define("SITE_UNKNOWN", 'site_unknown'); // идентификатор неизвестного сайта

define("BIND_DEFAULT", 'bind_default'); // идентификатор умолчальной связи
define("BIND_RIGHT",   'bind_right'); // идентификатор cсвязи прав

define("ACCOUNT_ROOT", 'root'); // идентификатор cсвязи прав
define("FILE_RIGHT",   0770); // файловые права на вновь создаваемые папки в fs

define("FOLDER_HOME",   'home');
define("FOLDER_TRASH",  'trash');
define("FOLDER_IMPORT", 'import');

define("DOMAIN_UNKNOWN",'domain_unknown');

define("JPEG_QUALITY", 50);

/* код ответа html */
$HTMLResponceCode = 0;


/**
 * установка кода ответа html
 */
function clSetHTMLResult($ACode)
{
    global $HTMLResponceCode;
    $HTMLResponceCode = $ACode;
}



/**
 * установка кода ответа html
 */
function clGetHTMLResult()
{
    global $HTMLResponceCode;
    return $HTMLResponceCode;
}



/**
 * получение корневого пути Catlair
 */
function clRootPath()
{
    return '/var/www/html/catlair';
}



/**
Return Site path
*/
function clSitePath($ASite)
{
    $Result = clRootPath() . '/site/' . $ASite;
    if (!file_exists($Result)) mkdir($Result, FILE_RIGHT, true);
    return $Result;
}


/**
Return Site config file
*/
function clSiteConfigPath($AIDSite)
{
   return clSitePath($AIDSite).'/config.json';
}



/**
 * возвращает путь для кэша
 */
function clCachePath($ASite)
{
    $Result = '/tmp/catlair/'.$ASite.'/cache';
    return $Result;
}





/*******************************************************************************
 * Функции для пуей PHP библиотек загружаемых при помощи cast
 */
 /*
 * Возвращает путь .
 * $AIDSite - идентификтор сайта
 */
function clLibraryPath($AIDSite)
{
    return clSitePath($AIDSite) . '/php';
}

/*
 * Возвращает полное имя файла библиотеки по имени
 * $AID - идентификтор дескрипта
 * $APath - путь ранее полученный функцией clDescriptPath
 */
function clLibraryFile($AName, $APath)
{
 return $APath . '/' . $AName . '.php';
}


function clLibraryFileAny($AName, $AIDSite)
{
    // пытаемся найти файл библиотеки c указанного сайта
    $PathName = clLibraryPath($AIDSite);
    $FileName = clLibraryFile($AName, $PathName);
    if (!file_exists($FileName) && $AIDSite!=SITE_DEFAULT)
    {
        clDeb('Library ['.$FileName.'] not found');
        // пытаемся найти файл библиотеки с умолчального сайта
        $PathName = clLibraryPath(SITE_DEFAULT);
        $FileName = clLibraryFile($AName, $PathName);
        if (!file_exists($FileName))
        {
            clDeb('Library ['.$FileName.'] not found');
            $FileName = false;
        }
    }
    return $FileName;
}

