<?php

/*****************************************************************************
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
*
* Controller example for Catlair.
*
* 01.09.2019
*
* still@itserv.ru
*
*/


include_once ROOT.'/datasource/data_factory.php';

class DescriptData extends TCMSController
{

    /*
    Create datasource. If datasourece exists, it will be deleted.
    Create personal user for datasource.
    Grant admin permissions for new datasource.
    */
    public function Create()
    {
        /* Collect params */
        $IDSite = $this->GetSite();
        $IDDatasource = $this->GetIncome('IDDatasource', TDataFactory::MYSQL);

        $Host = $this->GetIncome('Host', 'localhost');  /* Host SQL server */
        $Login = $this->GetIncome('CurrentAdminLogin', 'user');    /* LoginSQL server */
        $Password = $this->GetIncome('CurrentAdminPassword', '******'); /* Password SQL server */
        $DatabasePrefix = $this->GetIncome('DatabasePrefix', 'default');  /* New database name */

        /* Create new params based on income params */
        $NewLogin = $IDSite.'_'.$DatabasePrefix.'_admin';
        $NewDatabase = $IDSite.'_'.$DatabasePrefix;
        $NewPassword = $this->GetBuilder()->CreatePassword($IDSite, $NewDatabase, 32);

        /* Create datasource */
        $Datasource = $this->GetBuilder()->GetDataFactory()->Create($IDDatasource);
        if ($Datasource == null)
        {
            $this->SetCode('ErrorCreateDatasource');
            $this->SetMessage('Error create datasource object');
        }
        else
        {
            /*Connect to database*/
            $Datasource->SetHost($Host)->SetLogin($Login)->SetPassword($Password);
            $Datasource->Open();
            $this->SetCode($Datasource->GetResultCode());
            $this->SetMessage($Datasource->GetResultMessage());

            if ($this->IsOk())
            {
                /* Check existing the database and delete if exists */
                if ($Datasource->DatabaseExists($NewDatabase))
                {
                    /* Delete database */
                    $Datasource->DatabaseDelete($NewDatabase);
                    $this->SetCode($Datasource->GetResultCode());
                    $this->SetMessage($Datasource->GetResultMessage());
                }

                /* Create database */
                if ($this->IsOk())
                {
                    $Datasource->DatabaseCreate($NewDatabase, [/*'Codepage'=>'utf8mb4'*/]);
                    $this->SetCode($Datasource->GetResultCode());
                    $this->SetMessage($Datasource->GetResultMessage());
                }

                /* Select database as active*/
                if ($this->IsOk())
                {
                    $Datasource->SetDatabase($NewDatabase)->DatabaseSelect();
                    $this->SetCode($Datasource->GetResultCode());
                    $this->SetMessage($Datasource->GetResultMessage());
                }

                /* Create database administrator */
                if ($this->IsOk() && $Datasource->UserExists($NewLogin, $Host))
                {
                    $Datasource->UserDelete($NewLogin, $Host);
                    $this->SetCode($Datasource->GetResultCode());
                    $this->SetMessage($Datasource->GetResultMessage());
                }

                /* Create database admin with new login & password*/
                if ($this->IsOk())
                {
                    $Datasource->DatabaseAdminCreate($NewLogin, $NewPassword);
                    $this->SetCode($Datasource->GetResultCode());
                    $this->SetMessage($Datasource->GetResultMessage());
                }


                /* Create descript table */
                if ($this->IsOk())
                {
                    /* Create descript table */
                    $Datasource->TableCreate
                    (
                        'Descript',
                        [
                            ['Name'=>'ID',          'Type'=>TDataCore::TYPE_BIN,            'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                        ],
                        []
                    );

                    /* Create config table */
                    $Datasource->TableCreate
                    (
                        'Config',
                        [
                            ['Name'=>'IDDescript',  'Type'=>TDataCore::TYPE_BIN,            'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                            ['Name'=>'IDType',      'Type'=>TDataCore::TYPE_BIN,            'Length'=>16],
                            ['Name'=>'IDTypeChild', 'Type'=>TDataCore::TYPE_BIN,            'Length'=>16],
                            ['Name'=>'IDImage',     'Type'=>TDataCore::TYPE_BIN,            'Length'=>16],
                            ['Name'=>'Enabled',     'Type'=>TDataCore::TYPE_BOOLEAN],
                            ['Name'=>'Indexate',    'Type'=>TDataCore::TYPE_BOOLEAN],
                            ['Name'=>'DTActual',    'Type'=>TDataCore::TYPE_MOMENT]
                        ],
                        []
                    );

                    /* Create caption table */
                    $Datasource->TableCreate
                    (
                        'Caption',
                        [
                            ['Name'=>'IDRecord',  'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                            ['Name'=>'IDDescript','Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'IDLang',    'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'Caption',   'Type'=>TDataCore::TYPE_STRING_UNSIZE, 'Length'=>255],
                        ],
                        [['IDDescript','IDLang']]
                    );

                    /* Create caption table */
                    $Datasource->TableCreate
                    (
                        'Data',
                        [
                            ['Name'=>'IDRecord',  'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                            ['Name'=>'IDDescript','Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'IDLang',    'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'Data',      'Type'=>TDataCore::TYPE_BLOB],
                            ['Name'=>'MIME',      'Type'=>TDataCore::TYPE_STRING_UNSIZE, 'Length'=>255],
                            ['Name'=>'Extention', 'Type'=>TDataCore::TYPE_STRING_UNSIZE, 'Length'=>32]
                        ],
                        [['IDDescript','IDLang']]
                    );

                    /* Create сontent table */
                    $Datasource->TableCreate
                    (
                        'Content',
                        [
                            ['Name'=>'IDRecord',  'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                            ['Name'=>'IDDescript','Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'IDLang',    'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'Content',   'Type'=>TDataCore::TYPE_BLOB]
                        ],
                        [['IDDescript','IDLang']]
                    );

                    /* Create param table */
                    $Datasource->TableCreate
                    (
                        'Params',
                        [
                            ['Name'=>'IDDescript',  'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                            ['Name'=>'Params',      'Type'=>TDataCore::TYPE_JSON]
                        ],
                        []
                    );

                    /* Create config table */
                    $Datasource->TableCreate
                    (
                        'History',
                        [
                            ['Name'=>'IDRecord',    'Type'=>TDataCore::TYPE_BIN,            'Length'=>16,   'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'TableName',   'Type'=>TDataCore::TYPE_STRING_UNSIZE,  'Length'=>255,  'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'IDUser',      'Type'=>TDataCore::TYPE_BIN,            'Length'=>16,   'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'Moment',      'Type'=>TDataCore::TYPE_MOMENT,                         'Default'=>TDataCore::NOT_EMPTY]
                        ],
                        [['IDRecord','TableName']]
                    );

                    /* Create bind table */
                    $Datasource->TableCreate
                    (
                        'Bind',
                        [
                            ['Name'=>'IDRecord', 'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY, 'Key'=>TDataCore::KEY_PRIMARY],
                            ['Name'=>'IDParent', 'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'IDChild',  'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                            ['Name'=>'IDBind',   'Type'=>TDataCore::TYPE_BIN, 'Length'=>16, 'Default'=>TDataCore::NOT_EMPTY],
                        ],
                        [['IDParent'],['IDChild'],['IDParent', 'IDChild']]
                    );
                }


                if ($this->IsOk())
                {
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'IDToStr'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'InsertHistory'))->Call();

                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'DescriptByID'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'DescriptFlush'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'DescriptRead'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'DescriptExists'))->Call();

                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'CaptionFlush'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'ContentFlush'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'ContentGet'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'ConfigByID'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'BindAdd'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'BindDelete'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'DataFlush'))->Call();

                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'ParamsFlush'))->Call();
                    $Datasource->LoadCommand($this->SQLSourceFile($Datasource->GetType(),'ParamsRead'))->Call();

                }
            }

            if ($this->IsOk())
            {
                /* database store config */
                $Datasource->SetHost($Host)->SetLogin($NewLogin)->SetPassword($NewPassword)->SetDatabase($NewDatabase);
                $Datasource->StoreConfig($this->GetBuilder()->GetDatasourceConfig($IDSite, $DatabasePrefix));
            }
        }
        return $this;
    }

    private function SQLSourceFile($AType, $AName)
    {
        return ROOT.'/controller/DescriptData/'.$AType.'/'.$AName.'.sql';
    }

}
