<?php
/**
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
*
* Catlair PHP
* Controller foo files
* 01.09.2019 - still@itserv.ru
*/

class File extends TCMSController
{
    public function Upload()
    {
        $this->GetBuilder()->Debug()->Param('Received files', count($_FILES));

        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $IDParent = $this->GetIncome('IDParent', null);
        $ID = $this->GetIncome('ID', null);
        $Caption = $this->GetIncome('Caption', $ID);

        if ($IDParent == null && $ID == null) $Result = 'UnknownParentAndDescript';
        else
        {
            foreach ($_FILES as $File)
            {
                $Result=rcUnknown;
                $d = new TFile();

                /* Try read file with ID or FileName */
                if ($ID != null || $ID == '') $ID = $File['name'];

                /* проверяем наличие дескрипта */
                if (clDescriptExists($IDSite, $ID))
                {
                    $Result = $d->Read($ID, $IDSite);
                    /* если удалось прочтитать надо проверить лежит ли он в переданной папке */
                    if ($Result == rcOk)
                    {
                        $Result = $d->ParentRead();
                        if (!$d->ParentExist($IDParent, BIND_DEFAULT))
                        {
                            $Result='NeedCreate';
                            /* генерим новое имя */
                            $ID = clGUID() . '.' . pathinfo($ID, PATHINFO_EXTENSION);
                        }
                    }
                }

                /* Формируем новый дескрип если не все в порядке с резульатом */
                if ($Result != rcOk)
                {
                    $Result = $d->Create($ID, TYPE_FILE, $IDSite);
                    if ($Result == rcOk)
                    {
                        $d->SetLang($IDLang, 'Caption', $File['name']);
                        $Parent=new TDescript();
                        /* Чтение папки */
                        $Result=$Parent->Read($IDParent, $IDSite);

                        if ($Result == rcOk)
                        {
                            // Установка связей для родителя
                            $Result=$d->BindBegin($Parent);
                            $Result=$d->Bind($Parent, BIND_DEFAULT, false);
                            $Result=$d->Bind($Parent, BIND_RIGHT, false);
                            $Result=$d->BindEnd($Parent);
                        }
                        unset($Parent);
                    }
                    $Result = $d->Flush();
                }

                /* Если файл успешно подготовлен и ошибок нет при привязке то прописываем параметры */
                if ( $Result == rcOk && $d->Prepared())
                {
                    /* Запись параметров дескрипта */
                    $Result = $d->Import($File['tmp_name'], $IDLang);
                    if ($Result == rcOk)
                    {
                        // Удаляем кэш файла если он графика
                        $d->CacheDelete($IDLang);
                        // Возвращаем результа записи
                        $this->SetOutcome('ID', $d->ID);
                        $this->SetOutcome('IDParent', $IDParent);
                    }
                }

                /* Разрушаем дескрипт */
                unset($d);
            }
        }

        $this->SetCode($Result);
        return $this;
    }
}
