<?php
/**
Catlair PHP Copyright (C) 2019  a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.


Catlair PHP
Controller foo files
01.09.2019 - still@itserv.ru
*/


class Site extends TCMSController
{
    /*
    Create new site
    */
    public function Create()
    {
        $IDLang = $this->GetLang();
        $IDSite = $this->GetIncome('IDSite','');
        $Caption = $this->GetIncome('Caption', $IDSite);

        /* Если сессия гостевая и сессия не инсталляционная то ошибка */
        if ($this->GetBuilder()->GetSession()->IsGuest()) $Result = 'SessionIsNotAuth';
        else
        {
            if ($IDSite=='') $Result='UnknownIdentify';
            else
            {
                $d = new TDescript('');
                $Result = $d->Create($IDSite, TYPE_SITE, $IDSite);
                if ($Result==rcOk)
                {
                    // Запись параметров дескрипта
                    $d->SetLang($IDLang, 'Caption', $Caption);

                    // Установка связей для родителя
                    $Parent = new TDescript();
                    $Result = $Parent->Read('home', $IDSite);
                    $Result = $d->BindBegin($Parent);
                    $Result = $d->Bind($Parent, BIND_DEFAULT, false);
                    $Result = $d->Bind($Parent, BIND_RIGHT, false);
                    $Result = $d->BindEnd($Parent);
                    unset($Parent);

                    if ($Result == rcOk) $Result = $d->Flush();
                }
                unset($d);
            }
        }

        $this->SetCode($Result);
        return $this;
    }
}
