<?php

/**
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
*
* Объект обработки результатов исполнения публичных процедур
* в Content принимается собстветнно контент
* в процессе работы производится сборка параметров при помощи Set()
* при завершении сборки вызывается End().
* в зависимости от его наличия контента производится либо подмена ключей
* %key% в нем, либо параметры собираются в XML структуру.
*
* Струкура резульата
* <Catlair>
*      <Header Code="Код_Ошибки" Message="Сообщение об ошибке"/>
*      <Params>
*          <Name1>Значение</Name1>
*          <Name2>Значение</Name2>
*          ...
*      </Params>
*      <Data>
*          <Group1 Type="Array">
*              <Record1 Key1="Значение" Key2="Значение" ....>
*              <Record2 Key1="Значение" Key2="Значение" ....>
*              ...
*          </Group1>
*      </Data>
* </Catlair>
*
* still@itserv.ru
*/

include_once "debug.php";
include_once "cli_util.php";

/* Content type */
define ("tcAuto", 'Auto'); /* If content is absent then return XML else HTML */
define ("tcHTML", 'HTML'); /* Content type is HTML */
define ("tcXML", 'XML'); /* Content type is XML */
define ("tcJSON", 'JSON'); /* Content type is JSON. Now is not use. */
define ("tcNone", 'None'); /* Content not return. */


class TController
{
    private $Code = null; // Result code
    private $Message = null; // Result message
    private $FContent = null; // Content with macro in %Example%
    private $Params = null; // Array of params
    private $Income = null; // Array of params
    private $Data = array(); // Array of records
    private $Detale = array(); // Detale for arrays of records
    private $FTypeContent = tcAuto; //
    private $FReturnResult = true;
    private $FBuilder = null; /* Link to TBuilder */



    /*
    Constructor
    */
    public function __construct($ABuilder)
    {
        $this->FBuilder = $ABuilder;
        /* Create internal arrays */
        $this->Params = [];
        $this->Income = [];
        $this->Code = rcUnknown;
        $this->SetTypeContentIncome();
    }



    public function GetBuilder()
    {
        return $this->FBuilder;
    }



    /*
    Set content type
    */
    public function &SetTypeContent($AValue)
    {
        $this->FTypeContent = $AValue;
        return $this;
    }



    /*
    Set content type from income
    */
    public function &SetTypeContentIncome()
    {
        $this->FTypeContent = $this->GetIncome('TypeContent', tcAuto);
        return $this;
    }



    /*
     * Set return result flag
     */
    public function &SetReturnResult($AValue)
    {
        $this->FReturnResult = $AValue;
        return $this;
    }



    /*
     * Set content
     */
    public function &SetContent($AContent)
    {
        $this->FContent = $AContent;
        return $this;
    }



    /*
     * Get content
     */
    public function GetContent()
    {
        return $this->FContent;
    }



    /**
     * Set result code
     */
    public function &SetCode($AValue)
    {
        $this->Code = $AValue;
        return $this;
    }



    /**
     * Get result code
     */
    public function GetCode()
    {
        return $this->Code;
    }



    /**
    * Return true if is Ok
    */
    public function IsOk()
    {
        return $this->Code==rcOk;
    }




    /**
     * Set result message
     */
    public function &SetMessage($AValue)
    {
        $this->Message = $AValue;
        return $this;
    }



    /**
     * Set result message
     */
    public function GetMessage($AValue)
    {
        return $this->Message;
    }



    /**
     * Устанавливает значение параметра
     * Do not use. Use SetOutcome
     */
    public function &Set($AName, $AValue)
    {
        $this->Params[$AName] = $AValue;
        return $this;
    }



    /**
     * Устанавливает значение параметра
     * Do not use. Use GetOutcome
     */
    public function Get($AName, $ADefault)
    {
        if (array_key_exists($AName, $this->Params)) return $this->Params[$AName];
        else return $ADefault;
    }




    /**
     * Устанавливает значение параметра
     */
    public function &SetOutcome($AName, $AValue)
    {
        $this->Params[$AName] = $AValue;
        return $this;
    }



    /**
     * Устанавливает значение параметра
     */
    public function GetOutcome($AName, $ADefault)
    {
        if (array_key_exists($AName, $this->Params)) return $this->Params[$AName];
        else return $ADefault;
    }



    /**
     * Устанавливает значение входящего параметра
     */
    public function &SetIncome($AName, $AValue)
    {
        $this->Income[$AName] = $AValue;
        return $this;
    }



    /**
    Return income parameter $AName:string value or $ADefault:string
    It is coplex function return income params:
    - form get & post for CGI interface
    - command line or console inpur for CLI interface
    */
    public function GetIncome($AName, $ADefault)
    {
        if (array_key_exists($AName, $this->Income)) $r = $this->Income[$AName];
        else
        {
            switch (php_sapi_name())
            {
                case 'cgi':
                case 'fpm-fcgi':
                    /* cgi interface request params form GET or POST*/
                    if (array_key_exists($AName, $_GET)) $r = $_GET[$AName];
                        else if (array_key_exists($AName, $_POST)) $r = $_POST[$AName];
                            else $r=$ADefault;
                break;
                case 'cli':
                    /* CLI interface */
                    $r = GetIncomeCLI($AName, 'Input parameter', $ADefault, $this->FBuilder);
                break;
            }
        }
        return $r;
    }




    /**
     * Добавление ассоциативного массива как как очередная запись в сегдмент Data
     * $AGroup - имя группы записей. Если ранее отсутствовала - создается.
     * $AArray - массив именованых ключей в виде записи
     */
    public function &SetGroup($AGroup, $AName, $AValue)
    {
        // создание массива
        if (!array_key_exists($AGroup, $this->Detale)) $this->Detale[$AGroup] = [];
        $this->Detale[$AGroup][$AName]=$AValue;
        return $this;
    }



    /**
     * Добавление ассоциативного массива как как очередная запись в сегдмент Data
     * $AGroup - имя группы записей. Если ранее отсутствовала - создается.
     * $AArray - массив именованых ключей в виде записи
     */
    public function &AddRecord($AGroup, &$AArray)
    {
        // создание массива
        if (!array_key_exists($AGroup, $this->Data)) $this->Data[$AGroup] = [];
        array_push($this->Data[$AGroup], $AArray);
        return $this;
    }


    public function &Header($AValue)
    {
        switch (php_sapi_name())
        {
            case 'cgi':
            case 'fpm-fcgi':
                header($AValue);
            break;
        }
        return $this;
    }


    /*
     * Завершает сбор параметров и возвращает результат
     * в случае если подменный контент отсутствовал возвращается xml
     */
    public function End()
    {
        $this->FBuilder->BeginLabel('Build controller result');

        /*Получение собщения  по коду ошибки*/
        global $clSession;
 
        if ($this->Code==rcOk) $Message = 'Ok';
        else
        {
            if (clDescriptExistsAny($clSession->GetSite(), $this->Code)==false) $this->Message = $this->Code;
            else $this->Message = clDescriptContentByID($this->Code, $clSession->GetSite(), clGetLang(null));
        }

        if ($this->Code!=rcOk) $this->FBuilder->Warning()->Param('Result code',$this->Code)->Text(' '.$this->Message);

        /* Processing */
        $r = '';

        if ($this->FReturnResult)
        {
            /* Build XML content */
            if ($this->FTypeContent==tcXML || $this->FContent==null && $this->FTypeContent==tcAuto)
            {
                $this->FBuilder->BeginLabel('XML result');
                $r=XML_HEADER;
                $r.='<root>';
                $r.='<Header Code="' . $this->Code . '" ' . 'Message="' . $this->Message .'"/>';

                /* Сборка прочих параметров в список */
                $r.='<Params>';

                $this->FBuilder->BeginLabel('Dump result params');
                foreach ($this->Params as $Key => $Value)
                {
                    /* построение конента из параметра */
                    $r.='<'.$Key.'>' . encodeURIComponent($Value) . '</'.$Key.'>';
                    /* вывод в лог параметра */
                    $this->FBuilder->Debug()->Param($Key, $Value);
                }
                $this->FBuilder->End('');
                $r.='</Params>';

                /* Сборка списков в ключ Data */
                $r.='<Data>';
                foreach ($this->Data as $Name => $Array)
                {
                    //Сборка очередного списка
                    $r.='<'.$Name.' Type="Array">';
                    foreach ($Array as $Index => $Value)
                    {
                        // Сборка записи списка
                        $r.='<Record_'.$Index;
                        foreach ($Value as $NameP => $ValueP)
                        {
                            if (gettype($ValueP)!=='object')
                            {
                                $r .= ' ' . $NameP . '="';
                                $r .= encodeURIComponent((string)$ValueP).'"';
                            }
                        }
                        $r.='/>';
                    }
                    $r.='</'.$Name.'>';
                }
                $r.='</Data>';


                // Сборка списков в ключ Detale
                $r.='<Detale>';
                foreach ($this->Detale as $Name => $Array)
                {
                    //Сборка очередного списка
                    $r.='<'.$Name;
                    foreach ($Array as $Key => $Value)
                    {
                        // Сборка записи списка
                        if (gettype($Value)!=='object') $r.=' '.$Key.'="'.encodeURIComponent($Value).'"';
                    }
                    $r.='/>';
                }

                $r.='</Detale>';
                $r.='</root>';
                $this->Header('Content-Type: application/xml; charset=utf-8');
                $this->FBuilder->End();
            }



            /* Build JSON content */
            if ($this->FTypeContent == tcJSON)
            {
                $this->FBuilder->BeginLabel('JSON result');
                $this->Header('Content-Type: application/json; charset=utf-8');

                $Reflection = new stdClass();
                /* Header */
                $Reflection->Header = (object)['Code'=>encodeURIComponent($this->Code), 'Message'=>encodeURIComponent($this->Message)];


                /* Outcome params */
                $Reflection->Outcome = new stdClass();
                $Reflection->Params = new stdClass();
                if (count($this->Params)>0)
                {
                    foreach ($this->Params as $Key=>$Value) $Reflection->Outcome->$Key = encodeURIComponent($Value);
                    foreach ($this->Params as $Key=>$Value) $Reflection->Params->$Key = encodeURIComponent($Value);
                }


                /* Data record params */
                $Reflection->Data = new stdClass();
                foreach ($this->Data as $Name => $Array)
                {
                    /* Build list */
                    $Reflection->Data->$Name = [];
                    foreach ($Array as $Record) array_push($Reflection->Data->$Name, $Record);
                }

                $r=json_encode($Reflection);
                /*Set header*/
                $this->FBuilder->End();
            }


            /* Build HTML content */
            if ($this->FTypeContent==tcHTML || $this->FContent!='' && $this->FTypeContent==tcAuto)
            {
                $this->FBuilder->BeginLabel('HTML result');
                $this->header('Content-Type: text/html; charset=utf-8');
                /* добавление Code и Message что бы они подменились */
                $this->Set('Code', $this->Code);
                $this->Set('Message', $this->Message);
                /* подмена параметров */
                foreach ($this->Params as $Key => $Value) $this->FContent = str_replace('%'.$Key.'%', $Value, $this->FContent);
                $r=$this->FContent;
                $this->FBuilder->End();
            }
        }

        $this->FBuilder->End();
        return $r;
    }
}
