<?php

/**
Catlair PHP Copyright (C) 2019 a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

Descript
Система описание сущностей Descript
Базовый объект. Распространяет права. Участвует в поиске.

For any calls $this->ResutlCode mast equal rcOk.
*/


include_once "descript_utils.php";


class TDescript1
{
    const CONTENT_NONE =  'none';
    const CONTENT_ALL = 'all';
    const RIGHT_UPDATE =  'right_update';
    const RIGHT_INSERT = 'right_insert';
    const RIGHT_DELETE = 'right_delete';
    const FOF_FOE = 'Foe';
    const FOF_FRIEND = 'Frend';
    const TYPE_FOLDER = 'Folder'; // умолчальный идентификатор дескрипта

    /* Параметры */
    public $ID = null; /* Identifer descript */
    public $IDLang = null; /* Идетификатор текущего языка для дескрипта */
    public $IDSiteSource = null; /* Идетификатор сайта из которого дескрипт загружен */
    public $IDSiteRequest = null; /* Идетификатор сайта для которого десрипт запрошен */

    public $IDType = null; // Тип дескрипта
    public $IDTypeChild = null; // Тип дескрипта
    public $IDImage = null; /* Идентификатор картинки */
    public $Indexate = false; // Тип дескрипта
    public $Enabled = false; // Тип дескрипта
    public $DTActual = null; /* Идентификатор картинки */

    public $Caption = ''; /* заголовок */
    public $Content = ''; /* контент */
    public $Params = ''; /* параметры */

    /* Внутренние объекты */
    private $Casted; // Флаг того что успешно прошла процедура преобразования объекта через Cast
    public $DatasourceName = TDataFactory::DEFAULT;
    public $ResultCode = rcOk;


    /* Return current cms object */
    private function GetCMS()
    {
        global $CMS;
        return $CMS;
    }



    /* Возвращает родной датасоурс для десприпта при указанном сайте*/
    private function GetDatasource($AIDSite)
    {
        return $this->GetCMS()->GetDatasource($AIDSite, $this->DatasourceName);
    }



    /*
    Assign new descript structure without create or read
    Change RecultCode
    */
    public function Prepare($AID, $AIDSiteRequest)
    {
        if ($this->ResultCode == rcOk)
        {
            /* Получение имени и сайта из формата IDSite\IDDescript */
            $a=explode('\\',$AID);
            if (count($a)>1)
            {
                $AIDSite=$a[0];
                $AID=$a[1];
            }

            /* Create new ID */
            if ( $AID==null || $AID=='' || $AID=='null') $AID = clUUID();

            $this->ResultCode = clDescriptIDValidate($AID);
            if ($this->ResultCode == rcOk)
            {
                $this -> ID = $AID;
                $this -> IDType = null;
                $this -> IDTypeChild = null;
                $this -> IDImage = null;
                $this -> DTActual = null;
                $this -> Indexate = true;
                $this -> Enabled = true;

                $this -> IDSiteRequest = $AIDSiteRequest;
                $this -> IDSiteSource = null;
                $this -> IDLang = LANG_DEFAULT;
            }
        }
        return $this;
    }



    /**
    Проверка подготовлен ли дескрипт
    */
    public function Prepared()
    {
        if ($this->ResultCode == rcOk)
        {
            $Result = $this->ID!=null && $this->IDSiteRequest!=null;
            if (!$Result) $this->ResultCode = 'DescriptIsNotPrepared';
        }
        else $Result=false;

        return $Result;
    }



    /**
    Check exists descript
    */
    public function Exists()
    {
        $Result=false;
        if ($this->Prepared())
        {
            /* Request record by ID */
            $Datasource = $this->GetDatasource($this->IDSiteRequest);
            if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
            else $Result = $Datasource->Proc('DescriptByID', [IDToBin($this->ID)]) != null;
        }
        return $Result;
    }




    /**
    Flush prepared descript to datasource.
    Сохранение происходит на запрашиваемый сайт
    */
    public function &Flush()
    {
        if ($this->Prepared())
        {
            /* Преобразование в тип и выполненеие действия */
            $dc = $this->Cast();
            if (method_exists($dc, 'OnBeforeFlush')) $this->ResultCode = $dc->OnBeforeFlush();

            /* Сохранение данных в сайт для которого запрашивали дескрипт */
            $Datasource = $this->GetDatasource($this->IDSiteRequest);
            $Datasource->Proc
            (
                'DescriptFlush',
                [
                    'USER',
                    IDToBin($this->ID),
                    IDToBin($this->IDType),
                    IDToBin($this->IDImage),

                    IDToBin($this->IDTypeChild),
                    $this->Moment($this->DTActual),
                    $this->Indexate,
                    $this->Enabled
                ]
            );
            $this->ResultCode = $Datasource->GetResultCode();

            /* Исполнение после сохранения */
            if (method_exists($dc, 'OnAfterFlush')) $this->ResultCode = $dc->OnAfterFlush();

            /* Истребление кастованного объекта если он таковой */
            if ($dc->GetCasted()) unset($ds);
        }
        return $this;
    }



    /**
    Читает дескрипт
    $AID - иденттификатор дескрипта
    $AIDSite - сайт
    Descript must be prepared
    Result must be Ok
    */
    public function &ReadFromSite($AIDSite)
    {
        if ($this->Prepared())
        {
            /* Валидация дескрипта */
            $this->ResultCode = clDescriptIDValidate($this->IDSiteRequest);
            if ($this->ResultCode==rcOk)
            {
                /* Datasource select */
                $Datasource = $this -> GetDatasource($AIDSite);
                if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
                {
                    $Data = $Datasource->Proc('DescriptRead', ['USER', IDToBin($this->ID)])->Read();
                    if ($Data == null) $this->ResultCode = 'DescriptNotFound';
                    else
                    {
                        $this->ID = $Data->IDDescript;
                        $this->IDType = $Data->IDType;
                        $this->IDTypeChild = $Data->IDTypeChild;
                        $this->IDImage = $Data->IDImage;
                        $this->Indexate = $Data->Indexate;
                        $this->Enabled = $Data->Enabled;
                        $this->DTActual = $Data->DTActual;
                        $this->IDSiteSource = $AIDSite;
                    }
                }
            }
        }
        return $this;
    }



    /**
    Read descript from $IDSite or form DEFAULT_SITE it fist read was failed
    Descript must be prepared
    Result must be Ok
    */
    public function &Read()
    {
        if ($this->Prepared())
        {
            $this->ReadFromSite($this->IDSiteRequest);
            if ($this->ResultCode != rcOk)
            {
                $this->ResultCode = rcOk;
                $this->ReadFromSite(SITE_DEFAULT);
            }
        }
        return $this;
    }



    /*
    Change ID for descript
    */
    public function ChangeID($ANewID)
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($this->IDSiteSource);
            if ($Datasource == null) $Result = 'DatasourceNotFound';
            {
                $Datasource->Proc('DescriptChangeID',
                [
                    'USER',
                    IDToBin($this->ID),
                    IDToBin($ANewID)
                ]);
                $this->ResultCode = $Datasource->GetResultCode();
            }
        }
        return $this;
    }




    /*
    Return FOF status If descript is friend will return FOF_FRIEND else FOF_FOE.
    For friends Current site for Descript must be equal IDSite
    */
    public function GetFOFStatus()
    {
        if ($this->IDSiteSource === $this->IDSiteRequest) $Result =self::FOF_FRIEND;
        else $Result = self::FOF_FOE;
        return $Result;
    }



    /**
    преобразование дескрипта из элементарного.
    после создания дескрипта он является элементарным и не типизированным.
    после кнвертации возвращается копия дескрипта * подгружаются файл с именем
    класса classname.php * !!! элементарный дескрипт исходник разрушать нельзя до разрушения копии
    */
    public function &Cast()
    {
        $ClassName = "T".$this->IDType; // определяем тип класса Logger()->Debug()->Param('Convert to class', $ClassName);

        // проверяем зарегистрирован ли класс
        if (!class_exists($ClassName))
        {
            // если нет то грузим файл PHP с соответсвующим классом
            $FileName = clLibraryFileAny($this->IDType, $this->IDSiteRequest);
            Logger()->Debug()->Param('Library', $FileName);
            if ($FileName && file_exists($FileName)) include ($FileName);
            else Logger()->Debug()->Param('Library not found', $FileName);
        }

        // еще раз проверяем зарегистрирован ли класс
        if (class_exists($ClassName))
        {
            $Result = new $ClassName ();
            $Result->IDType = $this->IDType;
            $Result->IDTypeChild = $this->IDTypeChild;
            $Result->Caption = $this->Caption;
            $Result->DTActual = $this->DTActual;
            $Result->ID = $this->ID;
            $Result->IDSiteRequest = $this->IDSiteRequest;
            $Result->IDSiteSource = $this->IDSiteSource;
            $Result->DatasourceName = $this->DatasourceName;
            $Result->Casted = true;
        }
        else
        {
            $Result = $this;
            $Result->Casted = false;
        }

        return $Result;
    }



    public function GetCasted()
    {
        return $this->Casted;
    }



    public function GetEnabledStatus()
    {
        if ($this->GetEnabled()) $Result = 'On';
        else $Result = 'Off';
        return $Result;
    }



    /*
    Возвращает ID изображения
    Если у дескрипта не указано ШВ
    */
    public function GetIDImage($AIDDefault)
    {
        // Смотрим из текущей записи
        $Result = $this->IDImage;
        // проверяем если файл то его и возвращаем
        if ($Result == null && $this->IDType == TYPE_FILE) $Result = $this->ID;
        if ($Result == null)
        {
            /* Из типа объекта */
            $t=new TDescript();
            $t->Prepare($this->IDType, $this->IDSiteRequest);
            if ($t->Read()==rcOk) $Result = $t->IDImage;
            else $Result = $AIDDefault;
            unset($t);
        }
        return $Result;
    }



    /**
    Проверка права дескрипта
    */
    public function RightCheck($AIDRight)
    {
        global $clSession;
        /* если сессия существует те не cli, и сессия гостевая тогда ошибка s*/
        if ($clSession != null && $clSession->IsGuest()) $Result = 'no_'.$AIDRight;
        else $Result = rcOk;
        return $Result;
    }



    /*
     * Удаление дескрипта
     */
    public function &DeleteInternal()
    {
        if ($this->GetFOFStatus() == FOF_FOE) $this->ResultCode = 'FOFIsNotDelete';
        else
        {
            if ($this->Prepared())
            {
                /* Удаление всегда из сайта откуда был загружен дескрипт */
                $Datasource = $this -> GetDatasource($this-IDSiteRequest);
                if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
                else
                {
                    $Data = $Datasource -> Proc('DescriptDelete', ['USER', IDToBin($this->ID)] );
                    $this->ResultCode = $Datasource -> GetResultCode();
                }
            }
        }
        return $this;
    }



    public function Delete()
    {
        return $this->DeleteInternal();
    }



    /**
    Работа с параметрами
    Массивы зраняться в отдельных файлах от дескриптов
    */


    /**
    Flush params object to database as JSON
    */
    public function &ParamsFlush()
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($this->IDSiteRequest);
            if ($Datasource == null) $this->ResultCode='DatasourceNotFound';
            else
            {
                $Datasource->Proc('ParamsFlush', ['USER', IDToBin($this->ID), (string) json_encode ($this->Params)]);
                $this->ResultCode = $Datasource->GetResultCode();
            }
        }
        return $this;
    }



    /**
    Загружает объект параметров из источника, и возвращает его
    */
    public function &ParamsReadFromSite($AIDSite)
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($AIDSite);
            if ($Datasource == null) $this->ResultCode='DatasourceNotFound';
            else
            {
                $Data = $Datasource->Proc('ParamsRead', ['USER', IDToBin($this->ID)])->Read();
                if ($Data == null) $this->Params = json_decode ($Data->Params);
                $this->ResultCode=$Datasource->GetResultCode();
            }
        }
        return $this;
    }



    /**
    Read descript params form site or default site it fist read was failed
    Descript must be prepared
    */
    public function &ParamsRead()
    {
        if ($this->Prepared())
        {
            $this->ResultCode = $this->ParamsReadFromSite($this->IDSiteRequest);
            if ($this->ResultCode != rcOk)
            {
                $this->ResultCode = rcOk;
                $this->ParamsReadFromSite(SITE_DEFAULT);
            }
        }
        return $this;
    }



    /**
    Работа с контентом и заголовком дескрипта
    Контент хранится в отдельном файле
    Контент может быть взят из раличных фалов в зависимости от языка и сайта
    */


    /**
    Загружает конетнт
    */
    public function &ContentReadFromSite()
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($this->IDSiteRequest);
            if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
            else
            {
                $Data = $Datasource->Proc('ContentRead',
                    [
                        'USER',
                        IDToBin($this->ID),
                        IDToBin($this->IDLang),
                        IDToBin(LANG_DEFAULT)
                    ]
                )->Read();
                if ($Data!=null) $this->Content = $Data->Content;
                $this->ResultCode = $Datasource->GetResultCode();
            }
        }
        return $this;
    }



    /**
    Read caption descript from requested current site or form default site if fist read was failed
    */
    public function &ContentRead()
    {
        if ($this->Prepared())
        {
            $this->ResultCode = $this->ContentReadFromSite($this->IDSiteRequest);
            if ($this->ResultCode != rcOk)
            {
                $this->ResultCode = rcOk;
                $this->ContentReadFromSite(SITE_DEFAULT);
            }
        }
        return $this;
    }



    /**
    Записывает контент в Datasource
    */
    public function &ContentFlush()
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($this->IDSiteRequest);
            if ($Datasource == null) $this->ResultCode='DatasourceNotFound';
            else
            {
                $Datasource->Proc ('ContentFlush', ['USER', IDToBin($this->ID), IDToBin($this->IDLang), $this->Content]);
                $this->ResultCode=$Datasource->GetResultCode();
            }
        }
        return $this;
    }



    /**
    Read
    */
    public function &CaptionReadFromSite($AIDSite)
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($AIDSite);
            if ($Datasource == null) $this->ResultCode='DatasourceNotFound';
            else
            {
                $Data = $Datasource->Proc
                (
                    'CaptionRead',
                    [
                        'USER',
                        IDToBin($this->ID),
                        IDToBin($this->IDLang),
                        IDToBin(LANG_DEFAULT)
                    ]
                )->Read();
                if ($Data!=null) $this->Caption = $Data->Caption;
                $this->ResultCode = $Datasource->GetResultCode();
            }
        }
        return $this;
    }



    /**
    Read descript caption from $IDSite or form DEFAULT_SITE it fist read was failed
    */
    public function &CaptionRead()
    {
        if ($this->Prepared())
        {
            $this->ResultCode = $this->CaptionReadFromSite($this->IDSiteRequest);
            if ($this->ResultCode != rcOk)
            {
                $this->ResultCode = rcOk;
                $this->CaptionReadFromSite(SITE_DEFAULT);
            }
        }
        return $this;
    }



    public function &CaptionFlush()
    {
        if ($this->Prepared())
        {
            $Datasource = $this->GetDatasource($this->IDSiteRequest);
            if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
            else
            {
                $Datasource->Proc
                (
                    'CaptionFlush',
                    [
                        'USER',
                        IDToBin($this->ID),
                        IDToBin($this->IDLang),
                        $this->Caption
                    ]
                );
                $this->ResultCode = $Datasource->GetResultCode();
            }
        }
        return $this;
    }



    /*
     * подготовка контента из дескрипта.
     * $AIDLang - язык на котором выполняется построение контента
     * &$AResult - структура результата из файла result.php.
     */
    public function &ContentBuildInherited($AIDLang, $AIDSite, &$AResult)
    {
        if ($this->IDType==null || $this->IDType=='') $AResult->SetCode('DescriptTypeUnknown');
        else
        {
            if ($this->ID==null) $AResult->SetCode('DescriptIDUnknown');
            else
            {
                // сбор основных обязательных параметров
                $AResult -> Set('ID', $this->ID);
                $AResult -> Set('IDType', $this->IDType);
                // пользовательские параметры
                $AResult -> Set('Caption', $this->Caption);
                $AResult -> Set('IDTypeDefault', $this->IDTypeDefault);
                $AResult -> Set('Tag', StringToTag($this->Get('Tag', '')));
                // внешний вид
                $AResult -> Set('IDImage', $this->Get('IDImage', ''));
                $AResult -> Set('IDImagePreview', $this->GetIDImage(''));
                $AResult -> Set('ColorR', $this->Get('ColorR', 0));
                $AResult -> Set('ColorG', $this->Get('ColorG', 0));
                $AResult -> Set('ColorB', $this->Get('ColorB', 0));
                $AResult -> Set('ColorA', $this->Get('ColorA', 1));
                // настройки
                if ($this->Get('Indexate','')!='') $AResult->Set('Indexate', 'checked="checked"');
                else $AResult->Set('Indexate', '');
                if ($this->GetEnabled())
                {
                    $AResult->Set('Enabled', 'on');
                    $AResult->Set('EnabledFlag', 'On');
                }
                else
                {
                    $AResult->Set('Enabled', 'off');
                    $AResult->Set('EnabledFlag', 'Off');
                }
            }
        }
        return $this;
    }



    /**
    Стандартная внешняя функция обработки контента
    */
    public function &ContentBuild($AIDLang, $AIDSite, &$AResult)
    {
        $this->ContentBuildInherited($AIDLang, $AIDSite, $AResult);
        return $this;
    }



    /**
    Работа со связями дескриптов
    Родители объекта
    */



    /**
     * Копирует родительские связи себе с другого объекта
     */
    public function &ParentsCopyFrom($ASource)
    {
        if ($this->Prepared())
        {
        }
        return $this;
    }



    /*
     * Возвращае количество родителей объекта при переданной связи
     */
    public function ParentCount($AIDBind)
    {
        $Result=0;
        if ($this->Prepared())
        {
        }
        return $Result;
    }



    /*
    Проверяет наличие родителя в перечне
    */

     public function ParentExist($AIDParent, $AIDBind)
     {
        if ($this->Prepared())
        {
        }
        return $Result;
     }




    /**
    Дети объекта
    */


    /*
    Читает список детей объектов
    */
    public function ChildRead()
    {
        if ($this->Prepared())
        {
        }
        return $Result;
    }



    /**
    Копирует детские связи себе с другого объекта
    */
    public function ChildsCopyFrom($ASource)
    {
        if ($this->Prepared())
        {
        }
        return $Result;
    }


    /*
    Проверка наличия дочернего объекта
    */

    public function ChildExist($AIDChild, $AIDBind)
    {
        if ($this->Prepared())
        {
        }
        return $Result;
    }


    /**
    Получение списка связей по фильтру
    */

    public function ChildList($AIDChild, $AIDBind)
    {
    $r=array();
    foreach ($this->Child as $Bind)
    {
    if (($AIDChild=='*' || (string)$Bind['IDChild']==$AIDChild) &&
    ($AIDBind=='*' || (string)$Bind['IDBind']==$AIDBind))
    array_push($r, array('IDChild'=>$Bind['IDChild'],'IDBind'=>$Bind['IDBind']));
    }
    return $r;
    }



    /**
    Возвращает массив идентификаторов потомков по ID связи
    */

    public function ChildByBind($AIDBind)
    {
    $r=array();
    foreach ($this->Child as $Bind)
    {
    if ((string)$Bind['IDBind']==$AIDBind) array_push($r, (string)$Bind['IDChild']);
    }
    return $r;
    }



    /**
    Заменяет связь одну на другую
    */
    public function ChildConvertBind($AIDBindFrom, $AIDBindTo)
    {
        return rcOk;
    }



    public function ChildCount($AIDBind)
    {
        $Result=0;
        return $Result;
    }


    /**
    управление связями объекта
    */


    /*
     * Замещает связи свои другим объектом в одителях и детях
     */
    public function Replace($AOther)
    {
        if ($this->GetFOFStatus()=='Foe') $Result='FoeDoesNotReplace';
        else
        {
            $Result=$this->RightCheck(RIGHT_UPDATE);

            /* Операция с родителями */
            if ($Result==rcOk)
            {
                $Result = $this->ParentRead();
                if ($Result ==rcOk )
                {
                }
            }

        }
        return $Result;
    }



    /**
     * Перемещает объект из одного родителя в другой копируя связи
     */
    public function Move($AIDFrom, $AIDTo, $AIDBind)
    {
        if ($this->GetFOFStatus()=='Foe') $Result='FOFDoesNotMove';
        else
        {
            clLog('Moving Descript ['.$this->ID.'] from ['.$AIDFrom.'] to ['.$AIDTo.'] bind ['.$AIDBind.']', ltDeb);

            if ($AIDFrom==$AIDTo) $Result='EqualFromAndTo';
            else
            {
            }
        }
        return $Result;
    }



    public function &ChildAdd($AIDChild,$AIDBind)
    {
        if ($this->Prepared())
        {
            $Datasource = $this -> GetDatasource($this->IDSiteRequest);
            if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
            else
            {
                /* Flush Descript */
                $Datasource->Proc('BindAdd', [ 'USER', IDToBin($this->ID), IDToBin($AIDChild), IDToBin($AIDBind) ]);
                $this->ResultCode = $Datasource->GetResultCode();
            }
        }
        return $this;
    }



    public function &ParentAdd($AIDParent, $AIDBind)
    {
        $Datasource = $this -> GetDatasource($this->IDSiteRequest);
        if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
        else
        {
            $Datasource->Proc('BindAdd', ['USER', IDToBin($AIDParent), IDToBin($this->ID), IDToBin($AIDBind)]);
            $this->ResultCode = $Datasource->GetResultCode();
        }
        return $this;
    }



    public function &ChildDelete($AIDChild, $AIDBind)
    {
        $Datasource = $this -> GetDatasource($this->AIDSiteRequest);
        if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
        {
            $Datasource->Proc ('BindDelete',['USER', IDToBin($this->ID), IDToBin($AIDChild), IDToBin($AIDBind)]);
            $this->ResultCode = $Datasource->GetResultCode();
        }
        return $this;
    }



    public function &ParentDelete($AIDParent, $AIDBind)
    {
        $Datasource = $this -> GetDatasource($AIDSite);
        if ($Datasource == null) $this->ResultCode = 'DatasourceNotFound';
        {
            $Datasource->Proc ('BindDelete',['USER', IDToBin($AIDParent), IDToBin($this->ID), IDToBin($AIDBind)]);
            $this->ResultCode = $Datasource->GetResultCode();
        }
        return $this;
    }



    /**
    Рекурсивная трасировка дерва вниз начиная с текущего дескрипта по его детям
    */
    public function Trace($AIDBind, $ABefore, $AAfter, &$AParams, &$AStack)
    {
    clBeg('Tracing begin');
    // создание перечня обследованых узлов
    if ($AStack===null) $AStack=array();
    // Выполнеение действия над узлом
    if ($ABefore!=null) $Result=call_user_func($ABefore, $this, $AParams);
    // Сохранение узла как обработанного
    array_push($AStack, $this->ID);
    // Обработка
    $Result=$this->ChildRead();
    if ($Result==rcOk)
    {
    foreach ($this->Child as $Bind)
    {
    $IDChild=$Bind['IDChild'];
    $IDBind=$Bind['IDBind'];
    if (($AIDBind=='*' || $IDBind==$AIDBind) && array_search($IDChild, $AStack)===false)
    {
    $Child = new TDescript();
    if ($Child->Read($IDChild, $this->IDSite)==rcOk)
    {
    $Child->Trace($AIDBind, $ABefore, $AAfter, $AParams, $AStack);
    }
    unset($Child);
    }
    }
    }
    if ($AAfter!=null) $Result=call_user_func($AAfter, $this, $AParams);
    clEnd('Tracing end');
    return $Result;
    }



    /**
    Рекурсивная трасировка дерва верх начиная 1с текущего дескрипта по его детям
    */
    public function TraceParent($AIDBind, $ABefore, $AAfter, &$AParams, &$AStack)
    {
        clBeg('Tracing parent begin');

        // создание перечня обследованых узлов
        if ($AStack===null) $AStack=array();
        // Выполнеение действия над узлом
        if ($ABefore!=null) $Result=call_user_func($ABefore, $this, $AParams);
        // Сохранение узла как обработанного
        array_push($AStack, $this->ID);
        // Обработка
        $Result=$this->ParentRead();
        if ($Result==rcOk)
        {
            foreach ($this->Parent as $Bind)
            {
                $IDParent=$Bind['IDParent'];
                $IDBind=$Bind['IDBind'];
                if (($AIDBind=='*' || $IDBind==$AIDBind) && array_search($IDParent, $AStack)===false)
                {
                    $Parent = new TDescript();
                    if ($Parent->Read($IDParent, $this->IDSite)==rcOk)
                    {
                    $Parent->TraceParent($AIDBind, $ABefore, $AAfter, $AParams, $AStack);
                    }
                    unset($Parent);
                }
            }
        }
        if ($AAfter!=null) $Result=call_user_func($AAfter, $this, $AParams);

        clEnd('Tracing parent end');
        return $Result;
    }



    public function Moment($AValue)
    {
        if (($AValue)=='') $Result = null;
        else $Result = $AValue;
        return $Result;
    }



    /*
    */
    public function GetARGBHEX()
    {
        return
        sprintf('%02X', (1 - $this -> Get('ColorA', 1)) * 255).
        sprintf('%02X', $this -> Get('ColorR', 0) * 255).
        sprintf('%02X', $this -> Get('ColorG', 0) * 255).
        sprintf('%02X', $this -> Get('ColorB', 0) * 255);
    }
}
