<?php

/**
 * Catlair PHP
 *
 * Site
 *
 * 18.03.2019
 * still@itserv.ru
 */



class TSite extends TDescript
{
    /**
     * Конструктор
     */
    public function __construct()
    {
    }



    /**
     * Создает ссылку в реестре доменов на текущий домен
     */
    public function OnAfterFlush()
    {
        $FilePath = clSiteConfigPath($this->ID);
        $Config = [
            "IDSite" => $this->ID,
            "LogEnabled" => $this->GetArrayValue('Post', 'LegEnabled', true),
            "LogDebug" => $this->GetArrayValue('Post', 'LogDebag', false),
            "LogError" => $this->GetArrayValue('Post', 'LogError', true),
            "LogWarning" => $this->GetArrayValue('Post', 'LogWarning', true),
            "LogInfo" => $this->GetArrayValue('Post', 'LogInfo', true),
            "DatabaseName" => $this->GetArrayValue('Post', 'DatabaseName', ''),
            "DatabaseType" => $this->GetArrayValue('Post', 'DatabaseType', ''),
            "DatabaseLogin" => $this->GetArrayValue('Post','DatabaseLogin', ''),
            "DatabaseHost" => $this->GetArrayValue('Post','DatabaseHost', ''),
        ];

        $File = fopen($FilePath, 'w');
        if ($File === false) $Result='ErrorWriteSiteConfig';
        else
        {
            fwrite($File, json_encode($Config));
            fclose($File);
            $Result=rcOk;
        }
        return $Result;
    }



    /**
     */
    public function SiteParamsByDomain($ADomainName)
    {
        $Result=null;
        $FileName = clDomainListPath() . '/' . $ADomainName.'.json';
        if (file_exists($FileName))
        {
            $Size = filesize($FileName);
            if ($Size>0)
            {
                $File = fopen($FileName, 'r');
                if ($File!==false)
                {
                    $Result  = json_decode(fread($File, filesize($FileName)));
                    fclose($File);
                }
            }
        }
        return $Result;
    }
}

