<?php

/**
 * Catlair PHP
 *
 * домены
 *
 * 18.03.2019
 * still@itserv.ru
 */



class TDomain extends TDescript
{
    /**
     * Конструктор
     */
    public function __construct()
    {
    }


    /**
     * Создает ссылку в реестре доменов на текущий домен
     */
    public function OnAfterFlush()
    {
        $FilePath = clDomainListPath();
        if (!file_exists($FilePath)) mkdir($FilePath, FILE_RIGHT, true);
        $FileName = $FilePath.'/'.$this->ID.'.json';
        $DomainLink=[
            "IDDomain"=>$this->ID,
            "IDSite"=>$this->GetArrayValue('Post', 'IDSiteTarget', SITE_DEFAULT),
            "IDLang"=>$this->GetArrayValue('Post', 'IDLangDefault', LANG_DEFAULT),
            "IDContentStart"=>$this->GetArrayValue('Post', 'IDContentStart', ''),
            "DefaultURL"=> encodeURIComponent($this->GetArrayValue('Post', 'DefaultURL',''))
        ];
        $File = fopen($FileName, 'w');
        if ($File === false) $Result='ErrorWriteDomainReestr';
        else
        {
            fwrite($File, json_encode($DomainLink));
            fclose($File);
            $Result=rcOk;
        }
        return $Result;
    }
}



function clDomainListPath()
{
    return clRootPath() . '/domain';
}



/**

 */
function SiteParamsByDomain($ADomainName)
{
    $Result=null;
    $FileName = clDomainListPath() . '/' . $ADomainName.'.json';
    if (file_exists($FileName))
    {
        $Size = filesize($FileName);
        if ($Size>0)
        {
            $File = fopen($FileName, 'r');
            if ($File!==false)
            {
                $Result  = json_decode(fread($File, filesize($FileName)));
                fclose($File);
            }
        }
    }
    return $Result;
}
