<?php

/**************************************************************************************
 * Catlair PHP Copyright (C) 2019  a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 ******************************************************************************
 *
 * Catlair PHP
 * Пользовательские публичные функции
 * Рабочта дескриптом
 *
 * 16.03.2019
 *
 * still@itserv.ru
 *
 ******************************************************************************
 */


/*
 *  Чтение контента
 */

/**
 * Public function buid content list.
 */
function FileContentLoadPublic($AParams, $AResult)
{
    global $clSession;

    /*List of conditions*/
    $IDLang = clGetLang(clGetIncome('IDLang', $AParams, null));
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $RecordCurrent = (int)clGetIncome('RecordCurrent', $AParams, 0);
    $RecordCount = (int)clGetIncome('RecordCount', $AParams, 5);
    $IDParent = clGetIncome('IDParent', $AParams, null);
    $IDBind = BIND_DEFAULT;
    $ID = clGetIncome('ID', $AParams, null);
    $IDType = clGetIncome('IDType', $AParams, null);
    $IDRecord = clGetIncome('IDRecord', $AParams, null);

    /* Create find string */
    $Find = rawurldecode(clGetIncome('Find', $AParams, ''));
    if ($ID!=null) $Find .= ' ' . clIndexIDString($ID);
    if ($IDType!=null) $Find .= ' ' . clIndexTypeString($IDType);
    $Find = trim($Find);

    /* Build records by findstring */
    $Descripts = new TDescripts();
    $Descripts->LoadFromIndex($IDSite, $IDLang, $Find, $IDParent, $IDBind);

    /* Get total records */
    $AResult->SetGroup('Records', 'RecordTotal', $Descripts->RecordCount());
    /* Get descripts data */
    $Descripts->SelectDescript($IDSite, $IDLang, 'ID', $IDBind);
    /* Sorting */
    $Descripts->Sort('DTActual', -1);
    /* Paging */
    $Descripts->Cut($RecordCurrent, $RecordCount);
    /* Read content */
    $Descripts->SelectDescriptFields($IDSite, $IDLang, 'ID', ['Content'=>'Content']);
    $Descripts->SelectDescriptArray($IDSite, 'ID', 'Post', ['URLSource']);

    /* Set record current */
    $AResult->SetGroup('Records', 'RecordCurrent', $RecordCurrent+$Descripts->RecordCount());
    /* Return records*/
    $RecordContent = clDescriptContentByID($IDRecord, $IDSite, $IDLang);
    $AResult->SetContent($Descripts->BuildContent($RecordContent, 2));
    unset($Descript);
    /* End */
    return true;
}
