<?php
/******************************************************************************
 * Catlair PHP
 * CLI интерфейс
 * Инлексация дескрипта. Создание по идетификатору дескрипта поискового индекса.
 *
 * Параметры
 * - Маска идентификатора дескрипта (по умолчаию *)
 * - Идентификатор сайта (по умолчанию SITE_DEFAULT)
 * - Идентификатор языка (по умолчанию LANG_DEFAULT)
 *
 * still@itserv.ru
 */


include_once('/var/www/html/catlair/site/site_default/php/descript1.php');



class DescriptService extends TCMSController
{
    public function &Index()
    {
        if (php_sapi_name()!='cli') $this->SetCode('Indexate function only for CLI interface');
        else
        {
            $IDDescriptMask = $this->GetIncome('Mask', '*');
            $IDSite = $this->GetIncome('IDSite', SITE_DEFAULT);
            $IDLang = $this->GetIncome('IDLang', LANG_DEFAULT);
            $Clear = $this->GetIncome('Clear', 'false');

            // Check param login
            if ($IDDescriptMask == '') $this->SetCode('DescriptMaskEmpty');
            else
            {
                $this->GetBuilder()->BeginLabel('Indexate begin');

                if ($Clear=='true')
                {
                    $Index = new TIndex($this->GetBuilder());
                    $Index->Clear($IDSite, $IDLang);
                    unset($Index);
                }

                $FileMask = clDescriptsPath($IDSite).'/'.$IDDescriptMask;
                $this->GetBuilder()->Debug()->Param('FileMask',$FileMask);
                foreach (glob($FileMask) as $File)
                {
                    $IDDescript = pathinfo($File, PATHINFO_BASENAME);
                    $d = new TDescript();
                    $d->Read( $IDDescript, $IDSite);
                    $d->Index($IDLang, $Clear=='true');
                    unset($d);
                }

                $this->GetBuilder()->End();
            }
        }
        return $this;
    }



    public function &Test()
    {
        $IDSite = $this->GetIncome('IDSite', SITE_DEFAULT);
        $IDLang = $this->GetIncome('IDLang', LANG_DEFAULT);

        $Descript = new TDescript1();
        $Descript->DatasourceName = 'convert';
        $Result = $Descript->Prepare('root', SITE_DEFAULT)->Read()->CaptionRead()->ContentRead()->ParamsRead()->ResultCode;
        $this->GetBuilder()->Error()->Dump($Descript);
        $this->SetCode($Result);
        return $this;
    }



    public function &Convert()
    {
        $IDDescriptMask = $this->GetIncome('Mask', '*');
        $IDSite = $this->GetIncome('IDSite', SITE_DEFAULT);
        $IDLang = $this->GetIncome('IDLang', LANG_DEFAULT);

        if ($IDDescriptMask == '') $this->SetCode('DescriptMaskEmpty');
        else
        {
            $this->GetBuilder()->BeginLabel('Convert begin');
            $FileMask = clDescriptsPath($IDSite).'/'.$IDDescriptMask;
            $this->GetBuilder()->Debug()->Param('FileMask',$FileMask);
            foreach (glob($FileMask) as $File)
            {
                $IDDescript = pathinfo($File, PATHINFO_BASENAME);
                $s = new TDescript();
                $s->Read( $IDDescript, $IDSite);

                if ($s->Prepared())
                {
                    $this->GetBuilder()->Begin()->Param('ID',$s->ID);

                    $File = $s->ArrayLoad('Post');
                    $s->ParentRead();
                    $s->ChildRead();

                    $Dest = new TDescript1();
                    $Dest->Prepare($s->ID, $s->IDSite);
                    $Dest->IDType = $s->Type;
                    $Dest->IDLang = $IDLang;
                    $Dest->DatasourceName = 'convert';

                    $Dest->IDImage = $s->GetArrayValue('IDImage','Post',null);
                    $Dest->Indexate = $s->GetIndexate();
                    $Dest->Enabled = $s->GetEnabled();
                    $Dest->DTActual = $s->GetArrayValue('DTActual','Post',null);
                    $Dest->Flush();

                    /*Caption*/
                    $Dest->Caption = $s->GetLang($IDLang, 'Caption', '');
                    $Dest->CaptionFlush();

                    /*Параметры*/
                    $Dest->Params = $s->ArrayLoad('Post');
                    $Dest->ParamsFlush();

                    /* Converting begin */
                    $Dest->Content = $s->ContentRead($IDLang);
                    $Dest->ContentFlush();

                    /* Binds */
                    foreach ($s->Parent as $Bind) $Dest->ParentAdd($Bind['IDParent'], $Bind['IDBind']);
                    foreach ($s->Child as $Bind) $Dest->ChildAdd($Bind['IDChild'], $Bind['IDBind']);


                    $dc = $s->Cast();
                    if ($dc->Type == TYPE_FILE  && $dc->BinaryFileExists($IDLang)) $dc->Import($dc->BinaryFile($IDSite, $IDLang), $IDLang);
                    if ($dc->GetCasted()) unset($ds);


                    $this->GetBuilder()->End();
                }
                unset($s);
            }

            $this->GetBuilder()->End();
        }

        return $this;
    }
}
