<?php
/**********************************************************************************
Catlair PHP
Copyright (C) 2019 a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Datasource factory
*/

include_once ROOT.'/core/debug.php';


class TDataFactory
{
    const DEFAULT =     'default';
    const FILE =        'file';
    const MYSQL =       'mysql';
    const SQLITE =      'sqlite';
    const POSTGRESQL =  'postgresssql';
    const MSSQL =       'mssql';

    private $FLog = null;


    function  __construct($ALog)
    {
        $this->FLog = $ALog;
    }


    /*
    Create Datasource $ADataType with log system from $TLog
    Return datasource or null.
    */
    public function &Create($ADataType)
    {
        $Result = null;
        switch ($ADataType)
        {
            case self::MYSQL:
                include_once ROOT.'/datasource/mysql.php';
                $Result = new TMySQL($this->FLog);
            break;
            case self::DEFAULT:
                include_once ROOT.'/datasource/default.php';
                $Result = new TDefault($this->FLog);
            break;
            default:
                $this->FLog->Warning()->Param('Datatype not found', $ADataType);
            break;
        }
        return $Result;
    }
}
