<?php

/**
 * Catlair PHP
 * Пользовательские публичные функции
 * still@itserv.ru
 */


/*
 * Пользовательское создание новго дескрипта из формы
 */
function FileUploadPublic($AParams, $AResult)
{
    Logger()->Begin();
    Logger()->Debug()->Param('Received files', count($_FILES));

    global $clSession;
    /* Получение параметров */
    $Lang = clGetLang(clGetIncome('IDLang', $AParams, null));
    $Site = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $IDParent = clGetIncome('IDParent', $AParams, null);
    $ID = clGetIncome('ID', $AParams, null);
    $Caption = clGetIncome('Caption', $AParams, $ID);
    $RandomName = clGetIncome('RandomName', $AParams, 'false') == true;
    $CreateGroup = clGetIncome('CreateGroup', $AParams, 'false') == true;

    if ($IDParent == null && $ID == null) $Result = 'UnknownParentAndDescript';
    else
    {
        Logger()->Begin()->Text('Processing');
        foreach ($_FILES as $File)
        {
            $d = new TFile();
            $Result='Unknow';
            // Пытаемся прочитайть файл с указанными идентификаторм что бы потом грузить в него
            if ($ID != null) $Result = $d->Read($ID, $Site);
            /* Если по ID не прочится генерим идентификатор из имени файла */
            if ($Result!=rcOk)
            {
                $NewID = $File['name'];
                /* Создаем новое имя и читаем его еще раз */
                $Result = $d->Read($NewID, $Site);
                /* если файл открылся надо проверить лежит ли он в переданной папке */
                if ($Result == rcOk)
                {
                    $Result = $d->ParentRead();
                    if (!$d->ParentExist($IDParent, BIND_DEFAULT)) $Result='NeedCreate';
                }

                /* если файл не открыт с имением $NewID может небыло его может случайное имя */
                if ($Result!=rcOk || clDescriptExists($Site, $NewID))
                {
                    /* генерим новое имя */
                    $Ext = pathinfo($NewID, PATHINFO_EXTENSION);
                    $Name =  pathinfo($NewID, PATHINFO_FILENAME);
                    $NewID = clGUID() . '.' . $Ext;
                }

                if ($Result != rcOk)
                {
                    // Формируем новый дескрип
                    $Result = $d->Create($NewID, TYPE_FILE, $Site);
                    if ($Result == rcOk)
                    {
                        $Parent=new TDescript();
                        /* Чтение папки */
                        $Result=$Parent->Read($IDParent, $Site);

                        if ($Result == rcOk)
                        {
                            // Установка связей для родителя
                            $Result=$d->BindBegin($Parent);
                            $Result=$d->Bind($Parent, BIND_DEFAULT, false);
                            $Result=$d->Bind($Parent, BIND_RIGHT, false);
                            $Result=$d->BindEnd($Parent);
                        }
                        unset($Parent);
                    }
                }
            }

            // Если файл успешно подготовлен и ошибок нет при привязке то прописываем параметры
            if ( $Result == rcOk && $d->Prepared())
            {
                // Запись параметров дескрипта
                $d->SetLang(LANG_DEFAULT, 'Caption', $File['name']);
                $Result = $d->Import($File['tmp_name'], $Lang);
                if ($Result == rcOk)
                {
                    // Выполняем сохранение дескрипта
                    $Result = $d->Flush();
                    if ($Result == rcOk)
                    {
                        // Удаляем кэш файла если он графика
                        $d->CacheDelete($Lang);
                        // Возвращаем результа записи
                        $AResult->Set('ID', $d->ID);
                        $AResult->Set('IDParent', $IDParent);
                    }
                }
            }
            // Разрушаем дескрипт
            unset($d);
        }
        Logger()->End();
    }

    // обработка резульата
    $AResult->SetCode($Result);
    Logger()->End()->Text($Result);
    return true;
}



function FileGroupPublic($AParams, $AResult)
{
    Logger()->Begin();
    Logger()->Debug()->Param('Received files', count($_FILES));

    global $clSession;
    /* Получение параметров */
    $Lang = clGetLang(clGetIncome('IDLang', $AParams, null));
    $Site = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $IDParent = clGetIncome('IDParent', $AParams, null);

    $Parent=new TDescript();
    $Result=$Parent->Read($IDParent, $Site);
    if ($Result == rcOk)
    {
        // Формируем новый дескрип
        $IDGroup = clGUID();
        $Group = new TDescript();
        $Result = $Group->Create($IDGroup, TYPE_FOLDER, $Site);
        if ($Result == rcOk)
        {
            // Установка связей для родителя
            $Result=$Group->BindBegin($Parent);
            $Result=$Group->Bind($Parent, BIND_DEFAULT, false);
            $Result=$Group->Bind($Parent, BIND_RIGHT, false);
            $Result=$Group->BindEnd($Parent);
        }
        $Result = $Group->Flush();
        if ($Result==rcOk) $AResult->Set('IDGroup', $IDGroup);
        unset($Group);
    }
    unset($Parent);

    // обработка резульата
    $AResult->SetCode($Result);
    Logger()->End()->Text($Result);
    return true;
}

