<?php
/**
Catlair PHP
Copyright (C) 2019 a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

*/

class Account extends TCMSController
{
    /*
    Создание учетной записи для сайта
    */
    public function &Create()
    {
        /* List of conditions */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $IDLogin = $this->GetIncome('IDLogin', 'admin');

        if ($this->GetBuilder()->GetSession()->IsGuest()) $Result = 'SessionIsNotAuth';
        else
        {
            /* Check param login */
            $Site = new TDescript();
            $Result = $Site->Read($IDSite, $IDSite);
            if ($Result!=rcOk) $Result = 'ID site not found';
            else
            {
                if ($IDLogin == '') $Result = 'LoginNotFound';
                else
                {
                    if (clDescriptExists($IDSite, $IDLogin)) $Result = 'LoginExists';
                    else
                    {
                        $Account = new TAccount();
                        $Account->Create($IDLogin, TYPE_ACCOUNT, $IDSite);
                        // Запись параметров domen
                        $Account->SetLang(LANG_DEFAULT, 'Caption', $IDLogin);
                        // Установка связей c сайтом
                        $Result = $Account->BindBegin($Site);
                        $Result = $Account->Bind($Site, BIND_DEFAULT, false);
                        $Result = $Account->Bind($Site, BIND_RIGHT, false);
                        $Result = $Account->BindEnd($Site);
                        if ($Result == rcOk) $Result = $Account->Flush();
                        unset($Account);
                    }
                }
            }
            unset($Site);
        }

        /* Завершение */
        $this->SetCode($Result);
        return $this;
    }



    /*
    Создание учетной записи для сайта
    */
    public function &SetPassword()
    {
        $IDSite = $this->GetSite();
        $IDLogin = $this->GetIncome('IDLogin', 'admin');
        $Password = $this->GetIncome('Password', '');

        if ($Password == '') $Result = 'Passwordempty';
        else
        {
            $d = new TAccount();
            if ($d->Read($IDLogin, $IDSite)==rcOk) $Result=$d->SetPassword($Password);
            unset($d);
        }

        $this->SetCode($Result);
        return $this;
    }
}








