<?php
/**************************************************************************************
* Catlair PHP Copyright (C) 2019  a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
******************************************************************************
*
* Catlair PHP
*
* 08.09.2019
*
* still@itserv.ru
*
******************************************************************************
*/

class FileExchange extends TCMSController
{

    private function GetStoragePath($AIDSite, $AIDGroup)
    {
        $Result = clSitePath($AIDSite) . '/exchange/' . $AIDGroup;
        return $Result;
    }



    /*
     * Get file group
     */
    public function GetGroup()
    {
        $IDSite = $this->GetSite();
        $IDGroup = clGUID();
        $this->SetOutcome('IDGroup', $IDGroup);
        $this->SetCode(rcOk);
        return $this;
    }



    /*
     * Пользовательское создание новго дескрипта из формы
     */
    public function Upload()
    {
        /* Получение параметров */
        $IDSite = $this->GetSite();
        $IDGroup = $this->GetIncome('IDGroup', null);

        $this->GetBuilder()->Debug()->Param('Received files', count($_FILES))->Param('IDSite',$IDSite)->Param('IDGroup', $IDGroup);
        $Path = $this->GetStoragePath($IDSite, $IDGroup);

        /* Валидация имени */
        $Result = clDescriptIDValidate($IDGroup);

        if ($Result == rcOk)
        {
            /* Create directory */
            if (file_exists($Path)) $Result=rcOk;
            else
            {
                if (mkdir($Path, FILE_RIGHT, true)) $Result=rcOk;
                else $Result = 'ErrorCreateGroupFolder';
            }
            /* Загрузка файлов */
            foreach ($_FILES as $File)
            {
                if ($Result == rcOk)
                {
                    $Destination = $Path . '/' . $File['name'];
                    if (move_uploaded_file($File['tmp_name'], $Destination)) $Result=rcOk;
                    else $Result = 'ErrorMoveUploadedFile';
                }
            }
        }
        /* обработка резульата */
        $this->SetCode($Result);
        return $this;
    }



    public function DownloadList()
    {
        /* Получение параметров */
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $IDGroup = $this->GetIncome('IDGroup', null);
        $IDRecord = $this->GetIncome('IDRecord', null);

        $Result = clDescriptIDValidate($IDGroup);
        if ($Result==rcOk)
        {
            $Path = $this->GetStoragePath($IDSite, $IDGroup);
            if (file_exists($Path)) $Result=rcOk;
            else $Result='GroupNotFound';
        }

        if ($Result==rcOk)
        {
            $Descripts = new TDescripts();
            $List = scandir($Path);

            if (count($List)==0) $Result = 'FileNotFound';
            else
            {
                /* Build records */
                foreach($List as $FileName)
                {
                    if ($FileName!='.' && $FileName!='..')
                    {
                        $FilePath = $Path.'/'.$FileName;
                        $FileSize = clSizeToStr(filesize($FilePath),'0');
                        $Record=['FileName'=>$FileName, 'FileSize'=>$FileSize];
                        $Descripts->Insert($Record);
                    }
                }
                /* Return records*/
                $RecordContent = clDescriptContentByID($IDRecord, $IDSite, $IDLang);
                $this->SetContent($Descripts->BuildContent($RecordContent, 2));
                unset($Descript);
            }
        }

        $this->SetCode($Result);
        return $this;
    }



    public function Download()
    {
        /* Получение параметров */
        $IDSite = $this->GetSite();
        $IDGroup = $this->GetIncome('IDGroup', null);
        $IDFile = $this->GetIncome('IDFile', null);

        $Result = clDescriptIDValidate($IDGroup);
        if ($Result == rcOk)
        {
            $Result = clDescriptIDValidate($IDFile);
            if ($Result==rcOk)
            {
                $File = $this->GetStoragePath($IDSite, $IDGroup).'/'.$IDFile;
                clSendFile($IDFile, $File);
                $this->SetReturnResult(false);
            }
        }
        return $this;
    }
}
