<?php
/**
Catlair PHP Copyright (C) 2019  a@itserv.ru

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.


Catlair PHP
Session controller
01.09.2019 - still@itserv.ru
*/


class Session extends TCMSController
{
    /**
    Авторизация пользователя
    */
    public function Login()
    {
        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();

        $Login = $this->GetIncome('UserLogin', '');
        $Token = $this->GetIncome('Token', '');
        $Password = $this->GetIncome('UserPassword','');

        $Result = rcUnknown;

        /* Check param login */

        if ($Password == '' && $Token == '') $Result='ErrorAuthorizationDataEmpty';
        else
        {
            $d = new TAccount();

            /* Authorization by login */
            if ($Login != '' && $Token == '')
            {
                if ($Password == '') $Resut='ErrorPasswordEmpty';
                else
                {
                    if ($d->Read($Login, $IDSite) != rcOk) $Result='ErrorAccountNotFound'.$IDSite;
                    else
                    {
                        if (!$d->CheckPassword($Password)) $Result='ErrorCheckPassword';
                        else $Result=rcOk;
                    }
                }
            }

            if ($Login == '' && $Token != '')
            {
                if ($d->ReadByToken($Token, $IDSite)!=rcOk) $Result='ErrorAccountNotFound';
                else
                {
                    if (!$d->TokenCheckActual()) $Result='ErrorTokenNotActual';
                    else $Result=rcOk;
                }
            }

            if ($Result == rcOk)
            {
                $Session = $this->GetBuilder()->GetSession();
                $Session->Open(true);
                $Session->Set('Login', $d->ID);
                $Session->Set('LoginSite',$IDSite);
                if ($d->GetToken() != '') $Session->Set('Token',$d->GetToken());
                $Session->RoleBuild();
            }

            unset($d);
        }
        $this->SetCode($Result);
        return true;
    }



    /**
     * Завершение сесии пользоватея
     */
    public function Logout()
    {
        $Session = $this->GetBuilder()->GetSession();
        if ($Session->IsGuest()) $Result = 'SessionAlreadyGuest';
        else $Result = $Session->Close();
        $this->SetCode($Result);
        return true;
    }



    /**
     * Информация сессии
     */
    public function Info()
    {
        $Session = $this->GetBuilder()->GetSession();

        $IDLang = $this->GetLang();
        $IDSite = $this->GetSite();
        $Login = $Session->GetLogin();
        $LoginSite = $Session->Get('LoginSite','');

        $CaptionLanguage = clDescriptCaptionByID($IDLang, $IDSite, $IDLang);
        $CaptionSite = clDescriptCaptionByID($IDSite, $IDSite, $IDLang);

        $Account = new TAccount();
        if ($Account->Read($Login, $IDSite) == rcOk)
        {
            $IDUser = $Account->Get('IDUser','');
            $CaptionUser = clDescriptCaptionByID($IDUser, $IDSite, $IDLang);
        }
        else
        {
            $IDUser = '';
            $CaptionUser = '';
        }

        // Возвращаем параметры
        $this->SetOutcome('Login', $Login);
        $this->SetOutcome('LoginSite', $LoginSite);
        $this->SetOutcome('IDLanguage', $IDLang);
        $this->SetOutcome('IDSite', $IDSite);
        $this->SetOutcome('CaptionLang', $CaptionLanguage);
        $this->SetOutcome('CaptionSite', $CaptionSite);
        $this->SetOutcome('IDUser', $IDUser);
        $this->SetOutcome('CaptionUser', $CaptionUser);

        // Вывод результата
        $this->SetCode(rcOk);
        return true;
    }



    public function CurrentLogin()
    {
        $this->GetBuilder()->GetSession()->GetLogin();
    }


    //function DescriptRoleListPublic($AXML, $AContent)
    //{
    // global $clSession;
    // $IDLanguage = clGetLang(null);
    // $l=new TDescripts;
    // $l->LoadFromArray($clSession->Role, 'ID');
    // $l->Caption($IDLanguage, 'ID', 'Caption');
    // $Result=$l->Content($AContent);
    // unset($l);
    // return $Result;
    //}

}
