<?php
/**************************************************************************************
 * Catlair PHP Copyright (C) 2019  a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Стартовый файл Catlair.
 * вебсервер должен быть настроен на открытие данного файла.
 *
 *******************************************************************************
 *
 * Miscellaneous utilities
 *
 */



/**
 * Конвертация объема информации из байтов (int) в строку mb кб и прочее
 */
function clSizeToStr($ADelta, $AZero)
{
     if ($ADelta >= 1024*1024*1024*1024) $r=round($ADelta/(1024*1024*1024*1024),2).' TiB';
     else if ($ADelta >= 1024*1024*1024) $r=round($ADelta/(1024*1024*1024),2).' GiB';
         else if ($ADelta >= 1024*1024) $r=round($ADelta/(1024*1024),2).' MiB';
            else if ($ADelta >= 1024) $r=round($ADelta/1024,2).' KiB';
                else if ($ADelta > 0.1 && !$AZero) $r=$ADelta.' B';
                    else $r=$AZero;
     return $r;
}



/**
 * Analog for JS encodeURIComponent
 */
function encodeURIComponent($str)
{
    $revert = array('%21'=>'!', '%2A'=>'*', '%28'=>'(', '%29'=>')');
    $r = strtr(rawurlencode($str), $revert);
    $r = strtr($r, chr(39), '%27');
    return $r;
}



/*
 * Создание GUIDоподобной строки.
 */
function clGUID()
{
    /* !!! Надо будет переписать на нормальный алгоритм. */
     $A=str_pad(dechex(rand(0,hexdec('EFFFFFFF'))),8,'0');
     $B=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $C=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $D=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $E=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $F=str_pad(dechex(rand(0,hexdec('EFFFFFFF'))),8,'0');
     return $A.'-'.$B.'-'.$C.'-'.$D.'-'.$E.$F;
}
/*
 * Создание GUIDоподобной строки.
 */
function clUUID()
{
    /* !!! Надо будет переписать на нормальный алгоритм. */
     $A=str_pad(dechex(rand(0,hexdec('EFFFFFFF'))),8,'0');
     $B=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $C=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $D=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $E=str_pad(dechex(rand(0,hexdec('FFFF'))),4,'0');
     $F=str_pad(dechex(rand(0,hexdec('EFFFFFFF'))),8,'0');
     return $A.$B.$C.$D.$E.$F;
}



/*
 * Создание случайного инденификатора формата N-000.
 */
function clRndID($ALength)
{
    $Letter = 'ABDEFGHKLMNPRSTUXYZ';
    return substr($Letter, rand(0, strlen($Letter)-1), 1) . (string)rand(1, pow(10,$ALength));
}



/*
 * Получение параметров в порядке приоритета
 * $AXML - строка параметров полученная из процедуры
 * $_POST
 * $_GET
 */
function clGetIncome($AName, $AXML, $ADefault)
{
    $r=$ADefault;
    if ($AXML!=null && $AXML[$AName]) $r=$AXML[$AName];
    else
    {
        switch (php_sapi_name())
        {
         case 'cgi':
         case 'fpm-fcgi':
            if (array_key_exists($AName, $_GET)) $r = $_GET[$AName];
                else if (array_key_exists($AName, $_POST)) $r = $_POST[$AName];
         break;
         case 'cli':
            $Values = getopt(null, [$AName.':']);
            if (array_key_exists($AName, $Values)) $r = $Values[$AName];
         break;
        }
    }
    return $r;
}



/**
 * Используется для проверки корректности пути $APath:string дабы избежать ./../.
 */
function clPathControl($APath)
{
    $APath = str_replace ('/../', '', $APath);
    $APath = str_replace ('/../', '', $APath);
    $APath = str_replace ('/./', '', $APath);
    $APath = str_replace ('/'.'/', '', $APath);
    return $APath;
}



/*
 * Scatter string $AName = ABCD to path /A/B/C/ABCD with $ADepth for $ACharSet
 */
function clScatterName($AName, $ADepth, $ACharSet)
{
    $Result='';
    $l=mb_strlen($AName, $ACharSet);
    for ($i=0; $i<$ADepth && $i<$l; $i++) $Result .= '/' . mb_substr($AName, $i, 1, $ACharSet);
    return $Result . '/' . $AName;
}



/**
 * Удаление папки рекурсивное
 */
function clDeleteFolder($APath)
{
    if (is_dir($APath) === true)
    {
        $files = array_diff(scandir($APath), array('.', '..'));
        foreach ($files as $file) clDeleteFolder(realpath($APath) . '/' . $file);
        return rmdir($APath);
    }
    else
    {
        if (is_file($APath) === true) return unlink($APath);
    }
    return !file_exists($APath);
}



function StringToHex($AString)
{
    $hex="";
    for ($i=0; $i < strlen($AString); $i++) $hex .= dechex(ord($AString[$i]));
    return $hex;
}



function HexToString($hex)
{
    $string="";
    for ($i=0; $i < strlen($hex)-1; $i+=2) $string .= chr(hexdec($hex[$i].$hex[$i+1]));
    return $string;
}


/* Copy file with subfolders */
function FileCopy($src,$dst)
{
    $dir = opendir($src);
    @mkdir($dst);
    while (false !== ( $file = readdir($dir)) )
    {
        if (( $file != '.' ) && ( $file != '..' ))
        {
            if ( is_dir($src . '/' . $file) ) FileCopy($src . '/' . $file, $dst . '/' . $file);
            else copy($src . '/' . $file, $dst . '/' . $file);
        }
    }
    closedir($dir);
}



/*
 * Convert dirt string #tAg1 qwe #TAG2 to #tag1 #tag2
 */
function StringToTag($AString)
{
    return ($AString==null)?"":preg_replace('/ ?#END \Z/','',preg_replace('/(?:.|\n)*?(#\w+)/','$1 ',$AString.'#END'));
}



function IDToBin($AValue)
{
    if (strlen((string)$AValue)>16) $Result = hex2bin(md5((string)$AValue));
    else $Result = (string)$AValue;
    return $Result;
}
