<?php
/**********************************************************************************
* Catlair PHP
* Copyright (C) 2019 a@itserv.ru
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <https://www.gnu.org/licenses/>.
*
**********************************************************************************
*
* Обработка списков дескриптов
* Формирует список данных из разных источников в виде массива объектов ключ=значение
* Далее может собирать данные вокруг массива
*
* still@itserv.ru
*/



class TDescripts
{
    /*Массив значений*/
    public $Array = array();



    /******************************************************************************
    * формирование данных
    * операции стрящие список ID дескриптов на которые в последствии могет быть
    * применены процедуры сбора данных Select* и операции
    */


    /*
    * Формирование списка данных из простого одномерного массива
    * AArray - одномерный массив
    * AKeyField - имя поля в которое будет помещено значение массива
    */
    public function &LoadFromArray(&$AArray, $AField)
    {
        foreach ($AArray as $Index=>$Value) array_push($this->Array, array($AField=>$Value));
        return $this;
    }



    /*
    * Формирование списка данных из массива нумерованных ключей в формате KeyN =>Value где N - индекс от 0 до ...
    * AArray - массив ключей
    * AFields - массив (перечень) имен полей
    */
    public function &LoadFromArrayValues(&$AArray, $AFields)
    {
        Logger()->Begin();
        $Index = 0;
        do
        {
            $RecordExists = false;
            $Record = array();
            /* Перебор всех излвекаемых полей */
            foreach ($AFields as $Name)
            {
                /* Формируем имя возможного параметра */
                $FieldName = $Name . $Index;
                /* Проверяем наличие параметра во входящем массиве */
                $ValueExists = array_key_exists($FieldName, $AArray);
                $RecordExists = $RecordExists || $ValueExists;
                /* Если обнаружено значение то прописываем его в текущую запись, в противном случае прописываем Null*/
                if ($ValueExists) $Record[$Name] = (string)$AArray[$FieldName];
                else $Record[$Name] = null;
            }
            if ($RecordExists) array_push($this->Array, $Record);
            $Index++;
        }
        while ($RecordExists);
        Logger()->End();
        return $this;
    }



    /*
     * Формирование списка данных из POST данными в формает KEY_NUMBER_FIELD
     * AField - имя ключа KEY
     * Процедура перебирает весь пост выбирая поля начниающиеся с $AKey
     * читает индекс очередной
     */
    public function &LoadFromPost($AGroup)
    {
        Logger()->Begin();
        $LastIndex = null;
        /* Первый проход создание записей */
        foreach ($_POST as $Key=>$Value)
        {
            $a = explode('_', $Key, 3);
            if ($a[0]==$AGroup)
            {
                $Index = (int)$a[1];
                if ($LastIndex != $Index)
                {
                    array_push($this->Array, array());
                    $LastIndex = $Index;
                }
            }
        }
        /* Второй проход сбор данных */
        foreach ($_POST as $Key=>$Value)
        {
            $a = explode('_', $Key, 3);
            if ($a[0]==$AGroup)
            {
                $Index = (int)$a[1];
                $Name = $a[2];
                $this->Array[$Index][$Name] = $Value;
            }
        }
        Logger()->End();
        return $this;
    }



    /*
     * Выбор записей по поисковым парамерам при помощи индексатора
     */
    public function LoadFromIndex($AIDSite, $AIDLang, $AFind, $AIDParent, $AIDBind)
    {
        Logger()->Begin();
        /* Поиск по перечню детей */
        if ($AIDParent!=null)
        {
            $Parent = new TDescript();
            $Parent->Read($AIDParent, $AIDSite);
            $Parent->ChildRead();
            $ListChild = $Parent->ChildByBind($AIDBind);
            unset($Parent);
        }


        /* Поиск в идексиованных файлах */
        if ($AFind!='')
        {
            $Index = new TIndex(Logger());
            $ListFind = $Index->Find($AFind, $AIDLang, $AIDSite);
            unset($Index);
        }

        /* Определенеи результатов поиска в зависимости от родителя или строки поиск */
        if ($AIDParent==null && $AFind=='') $List = [];
        if ($AIDParent!=null && $AFind=='') $List = $ListChild;
        if ($AIDParent==null && $AFind!='') $List = $ListFind;
        if ($AIDParent!=null && $AFind!='') $List = array_intersect($ListChild, $ListFind);

        /* Построение списка дескриптов и возврат в виде записей */
        $this->LoadFromArray($List, 'ID'); // построение идеентификаторов
        Logger()->End();
    }


/******************************************************************************
 * выборки из дескриптов
 */

    /*
     * Выборка основных параметров дескрипта к списку записей
     * $IDLanguage - язык построения
     * $FieldID - имя поля с идентификатором
     */
    public function &SelectDescript($AIDSite, $AIDLang, $AFieldID, $AIDBind)
    {
        Logger()->Begin();
        foreach ($this->Array as &$Record)
        {
            if (!array_key_exists($AFieldID.'Descript', $Record))
            {
                $d=new TDescript();
                $r=$d->Read($Record[$AFieldID], $AIDSite);
            }
            else $d=$Record[$AFieldID.'Descript'];

            if ($d->Prepared())
            {
                // Сборка параметров
                $Record[$AFieldID.'Descript'] = $d;
                $Record['Caption'] = $d->GetLangAny($AIDLang, 'Caption', $d->ID);
                $Record['Indexate'] = $d->Get('Indexate', 'off');
                $Record['IDAccountInsert'] = $d->Get('IDAccountInsert', '');
                $Record['IDSiteInsert'] = $d->Get('IDSiteInsert', '');
                $Record['IDSite'] = $d->IDSite;
                $Record['FOF'] = $d->GetFOFStatus();
                $Record['Tag'] = $d->Get('Tag','');
                $Record['Enabled'] = $d->GetEnabledStatus();
                $Record['DTInsert'] = $d->Get('DTInsert', null);
                $Record['DTActual'] = $d->GetDTActual();
                // Изображение берется из самого дескрипта или из ссылки
                $Record['IDImagePreview'] = $d->GetIDImage('');

//                if ($d->ChildRead()==rcOk) $Record['ChildCount'] = $d->ChildCount($AIDBind);
//                else $Record['ChildCount']=0;
            }
            else $Record['Caption']=$r;
//            unset($d);
        }
        Logger()->End();
        return $this;
    }




    /*
     * Выборка основных параметров дескрипта к списку записей
     * $IDLanguage - язык построения
     * $FieldID - имя поля с идентификатором
     */
    public function &SelectDescriptFields($AIDSite, $AIDLang, $AFieldID, $AFields)
    {
        Logger()->Begin();
        foreach ($this->Array as &$Record)
        {
            /* Проверка наличия загруженного ранее дескрипта в массиве */
            if (!array_key_exists($AFieldID.'Descript', $Record))
            {
                $d=new TDescript();
                $r=$d->Read($Record[$AFieldID], $AIDSite);
            }
            else $d=$Record[$AFieldID.'Descript'];


            foreach ($AFields as $Source=>$Target)
            {
                if ($d->Prepared())
                {
                    switch ($Source)
                    {
                        case 'ID':                  $Record[$Target] = $d->ID; break;
                        case 'Caption':             $Record[$Target] = $d->GetLangAny($AIDLang, 'Caption', $d->ID); break;
                        case 'Content':             $Record[$Target] = $d->ContentRead($AIDLang); break;
                        case 'IDImage':             $Record[$Target] = $d->GetIDImage(''); break;
                        case 'FOF':                 $Record[$Target] = $d->GetFOFStatus(); break;
                        case 'DTInsert':            $Record[$Target] = $d->Get('DTInsert', null); break;
                        case 'IDAccountInsert':     $Record[$Target] = $d->Get('IDAccountInsert',null); break;
                        case 'IDSiteInsert':        $Record[$Target] = $d->Get('IDSiteInsert', null); break;
                        case 'IDSite':              $Record[$Target] = $d->IDSite; break;
                        case 'Enabled':             $Record[$Target] = $d->GetEnabledStatus(); break;
                        case 'ARGBHEX':             $Record[$Target] = $d->GetARGBHEX(); break;
                        default:                    $Record[$Target] = ''; break;
                    }
                }
                else $Record[$Target] = '';
            }

        }
        Logger()->End();
        return $this;
    }



    /*
     * Выборка основных параметров дескрипта к списку записей
     * $IDLanguage - язык построения
     * $FieldID - имя поля с идентификатором
     */
    public function &SelectChildsCount($AIDSite, $AFieldID, $AIDBind)
    {
        Logger()->Begin();
        foreach ($this->Array as &$Record)
        {
            if (!array_key_exists($AFieldID.'Descript', $Record))
            {
                $d=new TDescript();
                $r=$d->Read($Record[$AFieldID], $AIDSite);
            }
            else $d=$Record[$AFieldID.'Descript'];

            if ($d->Prepared())
            {
                if ($d->ChildRead()==rcOk) $Record['ChildCount'] = $d->ChildCount($AIDBind);
                else $Record['ChildCount']=0;
            }
        }
        Logger()->End();
        return $this;
    }



    public function &SelectPreview($ASource, $ADestination, $ALength)
    {
        Logger()->Begin();
        foreach ($this->Array as &$Record)
        {
            $Record[$ADestination] = Preview($Record[$ASource], $ALength);
        }
        Logger()->End();
        return $this;
    }



    /*
     * Получение данных по ключевому полю из массивов дескрипта
     *
     * $AIDSite - идентификатор сайта
     * $AFieldID - идентификатор ключевого поля
     * $AArrayName - имя поля с идентификатором
     * $AFileds - перечень полей для выбора из массива дескрипта
     */
    public function &SelectDescriptArray($AIDSite, $AFieldID, $AArrayName, $AFields)
    {
        Logger()->Begin();
        $Result = rcOk;
        foreach ($this->Array as &$Record)
        {
            if (!array_key_exists($AFieldID.'Descript', $Record))
            {
                // Создаем очредной дескрип и читаем его
                $d=new TDescript();
                $r=$d->Read($Record[$AFieldID], $AIDSite);
            }
            else $d=$Record[$AFieldID.'Descript'];

            if ($d->Prepared())
            {
                // Читаем массив из дескрипта
                $Post = $d->ArrayLoad($AArrayName);

                    foreach ($AFields as $Key)
                    {
                        // Получаем из поста значение по очередному ключу
                        if (array_key_exists($Key, $Post)) $Value=$Post[$Key];
                        else $Value=null;
                        $Record[$Key]=(string)$Value;
                    }
            }
            else foreach ($AFields as $Key) $Record[$Key]=null;
////            unset($d);
        }
        Logger()->End()->Param('Result',$Result);
        return $this;
    }



    /*
     * Get captions by ID
     */
    public function &SelectCaption($AIDSite, $AIDLang, $AFieldID, $AFieldCaption)
    {
        foreach ($this->Array as &$Record)
        {
            if (array_key_exists($AFieldID, $Record))
            {
                $Caption='';
                if ($Record[$AFieldID]!='')
                {
                    $d=new TDescript();
                    $r=$d->Read($Record[$AFieldID], $AIDSite);
                    if ($r==rcOk)
                    {
                        $Caption=$d->GetLangAny($AIDLang, 'Caption', '');
                        if ($Caption=="") $Caption=$d->ID;
                        $Record[$AFieldCaption]=$Caption;
                    }
                    else $Record[$AFieldCaption]=$r;
                    unset($d);
                }
                $Record[$AFieldCaption]=$Caption;
            }
        }
        return $this;
    }



    /*
     * Построение caption типов записей
     * $IDLanguage - язык построения
     * $FieldID - имя поля с идентификатором
     * $FieldCaptionType - имя поля куда будут помещены caption
     */
    public function &SelectCaptionType($AIDSite, $AIDLang, $AFieldID, $AFieldCaptionType)
    {
        foreach ($this->Array as &$Record)
        {
            $d=new TDescript();
            $r=$d->Read($Record[$AFieldID], $AIDSite);
            if ($r==rcOk) $Record[$AFieldCaptionType] = clDescriptCaptionByID($d->Type, $AIDSite, $AIDLang);
            else $Record[$AFieldCaptionType]=$d->Type;
            unset($d);
        }
        return $this;
    }



    /*
     * Установка значения полей
     */
    public function &Set($AFields)
    {
        foreach ($this->Array as &$Record)
        {
            foreach ($AFields as $Field=>$Value) $Record[$Field]=$Value;
        }
        return $this;
    }



/******************************************************************************
 * вывод данных
 */

    /*
     * Строит контент по списку записей используя шаблон
     * $ARecord - шаблон записи
     */
    public function BuildContent($ARecord, $ACountPath)
    {
        $Result = '';
        foreach ($this->Array as &$Record)
        {
            $Content = $ARecord;
            /* Цикл для подмены значений из записи в результате */
            for ($i=0; $i<$ACountPath; $i++)
            {
                /* Цикл для подмены полей */
                foreach ($Record as $Key=>$Value)
                {
                    switch (gettype($Value))
                    {
                        case 'object': $Value = '[object]'; break;
                        case 'NULL': $Value = 'NULL'; break;
                    }
                    $Content = str_replace('%'.$Key.'%', $Value, $Content);
                }
            }
            $Result = $Result . $Content;
        }
        return $Result;
    }



    /*
     * Выводит значение в лог
     */
    public function &Dump()
    {
        Logger()->Begin();
        foreach ($this->Array as $RecordKey => $Record)
        {
            Logger()->Begin()->Param('Item', $RecordKey)->Dump($Record)->End();
        }
        Logger()->End();
        return $this;
    }




    /**
     * Получение перечня записей с позиции
     * $ARecordCurrent - номер записи с которой необходимо начать построение
     * $ARecordCount - количество возвращаемых записей
     */
    public function &Cut($ARecordCurrent, $ARecordCount)
    {
        $this->Array = array_slice($this->Array, (int)$ARecordCurrent, (int)$ARecordCount);
        return $this;
    }



    /*
     * Сохранение списка дескриптов в виде результата TResult
     * $AResult - указаель на объект Result
     * $Group - имя группы в которую сохраняем
     */
    public function &BuildResult(&$AController, $AGroup)
    {
        Logger()->Begin();
        foreach ($this->Array as &$Record) $AController->AddRecord($AGroup, $Record);
        Logger()->End();
        return $this;
    }



    // Экстрагирует значения в массив по полю
    public function ExtractToArray($AKeyField)
    {
        $Result=array();
        foreach ($this->Array as &$Record) array_push($Result, $Record[$KeyField]);
        return $Result;
    }



/******************************************************************************
 * операции
 */


    /*
     * Сортировка по полю
     * $AField - имя поля
     * $ADirect - направление сортировки
     */


    public function &Sort($AField, $ADirect)
    {
        usort($this->Array, DescriptsSortCmp(['Field'=>$AField, 'Direct'=>$ADirect]));
        return $Result;
    }





    /*
     * Поиск первой записи в поле по значению
     * $AKeyField - поле
     * $AValue - значение
     */
    public function Find($AKeyField, $AValue)
    {
        $Result=null;
        $i=0;
        $c=count($this->Array);
        while ($i<$c && $Result === null)
        {
            if ( (string)$this->Array[$i][$AKeyField] == (string)$AValue) $Result = $i;
            $i++;
        }
        return $Result;
    }



    /*
     * Группирует записи по полю и сохраняет количество группированных записей
     */
    public function &Group($AKeyField, $ACountField)
    {
        $Result=new TDescripts;
        foreach ($this->Array as $Record)
        {
            $Search = $Result->Find($AKeyField, $Record[$AKeyField]);
            if ($Search === null)
            {
                $Record[$ACountField]=1;
                $Result->Insert($Record);
            }
            else
            {
                $Result->Array[$Search][$ACountField]++;
            }
        }
        $this->Array = $Result->Array;
        unset($Result);
        return $this;
    }



    /*
     * Переименование поля
     */
    public function &Rename($AFieldFrom, $AFieldTo)
    {
        foreach ($this->Array as &$Record)
        {
            $Record[$AFieldTo] = $Record[$AFieldFrom];
            unset( $Record[$AFieldFrom]);
        }
        return $this;
    }



    public function &Insert(&$ARecord)
    {
        array_push($this->Array, $ARecord);
        return $this;
    }



    public function RecordCount()
    {
        return Count($this->Array);
    }




 public function Search($AString, $AIDLanguage)
 {
  global $clSession;
  $IDSite = $clSession->GetSite();

  // Поиск в идексиованных файлах
  $Index = new TIndex(Logger());
  $Index->Prefix = $IDSite.'/'.$AIDLanguage;
  $Result = $Index->Find(trim(rawurldecode($AString)));
  unset($Index);

  $this->LoadFromArray($Result,'ID');
 }




 // пересечение с массивом по ключевому полю
 public function IntersectFromArray($AArray, $AKeyField)
 {
  $Result=array();
  foreach ($AArray as $Value)
  {
   $Record=$this($Find, $AKeyField, $AValue);
   if ($Record!=null) array_push($Result, $Record);
  }
  $this->Array=$Result;
  return true;
 }



 public function ChildCount($AIDBind)
 {
  foreach ($this->Array as &$Record)
  {
   $d=new TDescript($Record['ID']);
   $r=$d->ChildRead();
   if ($r==rcOk) $Record['ChildCount']=$d->ChildCount($AIDBind);
   else $Record['ChildCount']=0;
   unset($d);
  }
 }


 public function Content($AContent)
 {
  $Result='';
  foreach ($this->Array as $Record)
  {
   $Keys=array_keys($Record);
   $Line=$AContent;
   foreach ($Keys as $Key) $Line=str_replace('%'.$Key.'%', $Record[$Key], $Line);
   $Result.=$Line;
  }
  return $Result;
 }




    public function &Union($ADescripts, $AKeyField, $AEmptyRecord)
    {
        foreach ($this->Array as &$Record)
        {
            $Search=$ADescripts->Find($AKeyField, $Record[$AKeyField]);
            if ($Search==null) $Record = array_merge($Record, $AEmptyRecord);
            else $Record = array_merge($Record, $Search);
        }
        return $this;
    }


    /*
     * Фильтр по родителю
     */
    public function &FilterByParent($AIDSite, $AFielfdID, $AIDParent, $AIDBind)
    {
        $Result=null;
        $i=0;
        $c=count($this->Array);

        while ($i<$c && $Result==null)
        {
        $i++;
//            $Record =  $this->Array[$i];
//            $d=new TDescript();
//            $d->Assign($Record[$AFieldID], TYPE_DEFAULT, $AIDSite);
//            $d->ParetRead();
//            if ($d->ParentExist($AIDParent, $AIDBind)) $i++;
//            else array_splice($this->Array, i, 1);
//            unset($d);
        }
        return $this;
    }



    /**
     * Фильтр по родителю
     */
    public function &Filter($ACondition)
    {
        $Result=new TDescripts;
        foreach ($this->Array as $Record)
        {
            if (call_user_func($ACondition, $Record)) $Result->Insert($Record);
        }
        $this->Array = $Result->Array;
        return $this;
    }

} // Финал описания TDescripts





function DescriptsSortCmp($Params)
{
    return function ($a,$b) use ($Params)
    {
        if ($a[$Params['Field']] > $b[$Params['Field']]) return $Params['Direct'];
        else if ($a[$Params['Field']] < $b[$Params['Field']]) return -$Params['Direct'];
        else return 0;
    };
}


