<?php

/**************************************************************************************
 * Catlair PHP Copyright (C) 2019  a@itserv.ru
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 ******************************************************************************
 *
 * Catlair PHP
 * News engine
 *
 * 25.08.2019
 *
 * still@itserv.ru
 *
 ******************************************************************************
 */


/**
 * Public function buid content list.
 */
function NewsContentPublic($AParams, $AResult)
{
    global $clSession;

    /*List of conditions*/
    $IDLang = clGetLang(clGetIncome('IDLang', $AParams, null));
    $IDSite = clGetIncome('IDSite', $AParams,  $clSession->GetSite());
    $RecordCurrent = 0;
    $RecordCount = 0;
    $IDParent = clGetIncome('IDParent', $AParams, null);
    $IDBind = BIND_DEFAULT;

    /* Create find string */
    $Find = '';

    /* Build records by findstring */
    $Descripts = new TDescripts();
    $Descripts->LoadFromIndex($IDSite, $IDLang, $Find, $IDParent, $IDBind);
    /* Get descripts data */
    $Descripts->SelectDescript($IDSite, $IDLang, 'ID', $IDBind);
    /* Sorting */
    $Descripts->Sort('DTActual', -1);
    /* Paging */
    $Descripts->Cut(0, 4);

    /* Read content */
    $Descripts->SelectDescriptFields($IDSite, $IDLang, 'ID', ['Content'=>'Content']);

    /* Return records*/
    $AResult->Set('CaptionFirst', $Descripts->Array[0]["Caption"]);
    $AResult->Set('PreviewFirst', Preview($Descripts->Array[0]["Content"], 900));
    $AResult->Set('DTActualFirst', $Descripts->Array[0]["DTActual"]);
    $AResult->Set('IDFirst', $Descripts->Array[0]["ID"]);

    $AResult->Set('CaptionSecond', $Descripts->Array[1]["Caption"]);
    $AResult->Set('PreviewSecond', Preview($Descripts->Array[1]["Content"], 100));
    $AResult->Set('DTActualSecond', $Descripts->Array[1]["DTActual"]);
    $AResult->Set('IDSecond', $Descripts->Array[1]["ID"]);

    $AResult->Set('CaptionThird', $Descripts->Array[2]["Caption"]);
    $AResult->Set('PreviewThird', Preview($Descripts->Array[2]["Content"], 100));
    $AResult->Set('DTActualThird', $Descripts->Array[2]["DTActual"]);
    $AResult->Set('IDThird', $Descripts->Array[2]["ID"]);

    $AResult->Set('CaptionForth', $Descripts->Array[3]["Caption"]);
    $AResult->Set('PreviewForth', Preview($Descripts->Array[3]["Content"], 100));
    $AResult->Set('DTActualForth', $Descripts->Array[3]["DTActual"]);
    $AResult->Set('IDForth', $Descripts->Array[3]["ID"]);

    unset($Descript);

    /* End */
    return true;
}
